<?php 
get_header(); 
/*
 * Template Name: Contact Us
*/
?>

<?php
$the_query = new WP_Query('page_id=248');
while ($the_query->have_posts()) : $the_query->the_post();

// Get the featured image safely
$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
$url_img2 = ($thumb && isset($thumb[0])) ? $thumb[0] : get_template_directory_uri() . '/images/default-image.jpg'; // Fallback image

?>
        <div class="col_sm1 inner-banner" style="background: url(<?php echo esc_url($url_img2); ?>);">
            <div class="top2">
                <h2><?php the_title();?></h2>
                <p><?php the_content();?></p>
            </div>
            <div class="clear"></div>
        </div>

<?php endwhile; ?>


    <!-- about-us -->
    <div class="col_sm1 pd-tp">
        <div class="top2">

        <a name="enquire-now" style="position:relative;top:-50px;"></a>
            <div class="col_sm2_2 contact_form_bg contact_form_min_h tickty">


                <div class="frm_card">

                    <p><?php echo get_field("contact_us_tagline")?></p>
                </div>

                <div class="col_sm1 wow fadeInUp">
                    <form id="contactForm" name="contact" action="<?php echo get_template_directory_uri(); ?>/mail.php" method="post" enctype="multipart/form-data">
                        <fieldset2>
                            <input name="name" type="text" required id="name" tabindex="1" placeholder="Full Name">
                        </fieldset2>

                        <fieldset2>
                            <input name="email" type="email" required id="email" tabindex="2" placeholder="Email">
                        </fieldset2>
                        <fieldset2>
                            <input name="contact" type="text"  id="contact" tabindex="1" placeholder="Phone">
                        </fieldset2>
                        <fieldset2>
                            <input name="company" type="text"  id="company" tabindex="1" placeholder="Company / Organization">
                        </fieldset2>

                        <div class="clear"></div>
                        <fieldset2>
                            <textarea name="message" id="message" required tabindex="3"
                                placeholder="Message"></textarea>
                        </fieldset2>

                        <div class="clear"></div>
                        <!-- Recaptch -->
                        <!-- <div style="margin-left:1%;" class="g-recaptcha"
                            data-sitekey="6Lf6lTUqAAAAAKxv13Do4ne-MRXMDy1KAFlPCyVo">
                        </div> -->
                        <div class="clear"></div>
                        <br>

                        <button name="submit" type="submit" id="contact-submit" data-submit="...Sending"
                            tabindex="4">Send Message</button>

                    </form>
                    <div class="clear"></div>
                </div>
            </div>

            <div class="col_sm2_2 contact_form_bg_color contact_form_min_h">





                <div class="col_sm1 contact_form_bg_color2">
                    <br>
                    <div class="col_sm1 contact_form_bg_color2">
                        <div class="col_sm66">
                            <i class="fa-solid fa-envelope"></i>
                        </div>
                        <div class="col_sm666 contact_form_txt">
                            <strong>
                                <h2>Mail Us</h2>
                            </strong>
                            <div class="contact_flex"> <?php echo get_field("mail")?></div>
                        </div>
                        <div class="clear"></div>
                    </div>
                    <br>
                    <div class="col_sm66">
                        <i class="fa-solid fa-location-dot"></i>
                    </div>


                    <div class="col_sm666 contact_form_txt">
                        <strong>
                            <h2>Corporate Office</h2>
                        </strong>
                        <?php echo get_field("corporate_office_adress")?>
                    </div>

                    <div class="clear"></div>
                    <div class="col_sm66">
                        <i class="fa-solid fa-location-dot"></i>
                    </div>

                    <div class="col_sm666 contact_form_txt">
                        <strong>
                            <h2>Mumbai Branch Office</h2>
                        </strong>
                        <?php echo get_field("mumbai_branch_office_addres")?>
                    </div>
                    <div class="clear"></div>
                    <div class="col_sm66">
                        <i class="fa-solid fa-location-dot"></i>
                    </div>

                    <div class="col_sm666 contact_form_txt">
                        <strong>
                            <h2>Hyderabad Branch Office</h2>
                        </strong>
                        <?php echo get_field("hyderabad_branch_office_address")?>
                    </div>
                    <div class="clear"></div>

                    <br>
                    <div class="col_sm66">
                        <i class="fa-solid fa-location-dot"></i>
                    </div>


                    <div class="col_sm666 contact_form_txt">
                        <strong>
                            <h2>Manufacturing Unit Addresses</h2>
</strong>
                        <?php echo get_field("manufacturing_unit_1_address")?> <br>
                        <?php echo get_field("manufacturing_unit_2_address")?><br>

                    </div>
                    <div class="clear"></div>
                </div>
                <br>
                <div class="col_sm1 contact_form_bg_color2">

                    <br>
                    <div class="col_sm66">
                        <i class="fa-solid fa-link s-link"></i>
                    </div>


                    <div class="col_sm666 contact_form_txt">
                        <strong>
                            <h2>Connect With Us</h2>
                        </strong>

                        <div class="social-links2">
                            <a href="<?php echo get_field("linkedin_link")?>" target="_blank" class="social-link2"><i class="fab fa-linkedin"></i></a>
                            <a href="<?php echo get_field("instagram_link")?>" target="_blank" class="social-link2"><i class="fab fa-instagram"></i></a>
                            <a href="<?php echo get_field("facebook_link")?>" target="_blank" class="social-link2"><i class="fab fa fa-facebook"></i></a>
                            <a href="<?php echo get_field("twitter_link")?>" target="_blank" class="social-link2"><i class="fa-brands fa-x-twitter"></i></a>
                            <a href="https://wa.me/<?php echo get_field("whatsapp")?>" target="_blank" class="social-link2"><i class="fab fa-whatsapp whtsapp"></i></a>
                        </div>

                        <br><br>
                    </div>



                    <div class="clear"></div>
                </div>

                <br>
                <div class="col_sm1 contact_form_bg_color2">




                    <iframe
                        src="<?php echo get_field("map")?>"
                        width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>





                    <div class="clear"></div>
                </div>



            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div><br>
    </div>

<?php get_footer();?>