<?php get_header(); 
/*
 * Template Name: Search Page
*/
?>

<style>
    .post-flex{
        display:flex;
        flex-wrap:wrap;
    }
</style>

<div class="col_sm1 inner-banner">
    <div class="top2">
        <h2>Search Results for: <?php echo get_search_query(); ?></h2>
    </div>
    <div class="clear"></div>
</div>

<div class="col_sm1 overflow-hidden product2">
    <div class="col_sm1 search">
        <div class="top2">
        <div class="post-flex">
        <?php
        // ✅ Categories to exclude by slug
        $excluded_slugs = array( 'strength' , 'why_choose_us', 'product_categories', 'banner', 'sustainability' );

        // Get their IDs
        $excluded_ids = array();
        foreach ( $excluded_slugs as $slug ) {
            $cat = get_category_by_slug( $slug );
            if ( $cat ) {
                $excluded_ids[] = $cat->term_id;
            }
        }

        // Custom query for search
        $args = array(
            'post_type'       => array( 'page', 'post' ),
            's'               => get_search_query(),
            'category__not_in'=> $excluded_ids
        );

        $search_query = new WP_Query( $args );

        if ( $search_query->have_posts() ) :
            while ( $search_query->have_posts() ) : $search_query->the_post();

                $post_type = get_post_type();
                $link = get_permalink(); // default

                if ( $post_type === 'page' ) {
                    $parent_id = wp_get_post_parent_id( get_the_ID() );
                    if ( $parent_id ) {
                        $link = get_permalink( $parent_id );
                    }
                } elseif ( $post_type === 'post' ) {
                    $categories = get_the_category();
                    if ( ! empty( $categories ) ) {
                        $cat_slug = $categories[0]->slug;

                        // If the post belongs to excluded category → skip it
                        if ( in_array( $cat_slug, $excluded_slugs, true ) ) {
                            continue; // 🚫 don’t show this post
                        }

                        $page = get_page_by_path( $cat_slug );
                        if ( $page ) {
                            $link = get_permalink( $page->ID );
                        } else {
                            $link = get_category_link( $categories[0]->term_id );
                        }
                    }
                }
                ?>

                <div class="col_sm4 bdr single-post">
                    <div class="col_sm1 post-thumbnail">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <div class="col_sm1 post-thumbnail">
                                <a href="<?php echo esc_url( $link ); ?>">
                                    <?php the_post_thumbnail( 'full', array( 'class' => 'img' ) ); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="col_sm1 product_txt bg_clr4 bdr2">
                        <h2><a href="<?php echo esc_url( $link ); ?>"><?php the_title(); ?></a></h2>
                        <p><?php echo wp_trim_words( get_the_content(), 20, '...' ); ?></p>
                        <h5 class="get-quote2">
                            <a href="<?php echo esc_url( $link ); ?>" class="link2">View More <i class='fa-solid fa-angle-right'></i></a>
                        </h5>
                    </div>
                </div>

            <?php endwhile; ?>
        <?php else : ?>
            <p>No results found for "<strong><?php echo get_search_query(); ?></strong>".</p>
        <?php endif; ?>

        <?php wp_reset_postdata(); ?>
        </div>
        </div>
    </div>
    <div class="clear"></div>
</div>

<?php get_footer(); ?>
