<?php get_header() ?>

<?php
$page_id = 139;
$page = get_post($page_id);

if ($page) {
    // Featured image
    $thumb = wp_get_attachment_image_src(get_post_thumbnail_id($page->ID), 'full');
    $url_img2 = ($thumb && isset($thumb[0])) ? $thumb[0] : get_template_directory_uri() . '/images/default-image.jpg';
    ?>
    
    <div class="col_sm1 inner-banner" style="background: url(<?php echo esc_url($url_img2); ?>);">
        <div class="top2">
            <h2><?php echo esc_html(get_the_title($page->ID)); ?></h2>
            <p><?php echo apply_filters('the_content', $page->post_content); ?></p>
        </div>
        <div class="clear"></div>
    </div>
<?php
}
?>

<div class="col_sm1">
    <div class="top2"> <br><br>
    <div class="blog_sm8">
    <?php query_posts( $blog); ?>
                <?php while ( have_posts() ) : the_post(); ?>

                <?php
                    $thumb = wp_get_attachment_image_src( 
                    get_post_thumbnail_id(get_the_id()), 'full' );
                    $url_img = $thumb['0'];
                    ?>

            <div class="col_sm3 bullet category-sub zoomin">
                <div class="zoom">
                    <img src="<?php echo esc_url($url_img); ?>" class="img">
                </div> <br>
                <a href="<?php echo get_the_permalink(); ?>"> <h2><?php the_title(); ?></h2></a>
                    <p><?php echo wp_trim_words( get_the_content(), 14, '...'); ?></p><br>
                    <div class="btn2">
                <a href="<?php echo get_the_permalink(); ?>">Know More <i class='fa-solid fa-angle-right'></i> </a>
                    </div>
            </div>
            <?php endwhile; ?>  


                    </div>

            <div class="blog_sm88">
    <div class="blog_cat">
        <h3 class="sidebar-title">Recent Post</h3>
            <div class="s-border"></div>
            <div class="m-border"></div>
            <ul>
                <?php

                    $args = array
                    ( 
                       'category_name' => 'blog',
                       'posts_per_page'   => 3,
                       'orderby'          => 'date',
                       'order' => 'DESC'

                    );
                            
                    $query2 = new WP_Query( $args );
                             
                        if ( $query2->have_posts()):
                            while ( $query2->have_posts() ):
                                $query2->the_post(); ?>

                        <li><a href="<?php echo get_the_permalink(); ?>"><?php the_title(); ?></a></li>

                    <?php endwhile;  endif; wp_reset_postdata(); ?>
                        
            </ul>
    </div>
</div>

    </div>
    
    <div class="clear"></div> <br><br>
</div>

<!-- pagination start -->
<div class="col_sm1">
    <div class="col_sm1">
        <div class="center">
            <ul class="pagination">
                <?php
                    global $wp_query; // main query
                    $total_pages = $wp_query->max_num_pages;

                    if ($total_pages > 1) {
                        $current_page = max(1, get_query_var('paged')); // use 'paged', not 'page'
                        echo paginate_links(array(
                            'base' => get_pagenum_link(1) . '%_%',
                            'format' => '/page/%#%',
                            'current' => $current_page,
                            'total' => $total_pages,
                            'prev_text'    => __('<li><< prev</li>'),
                            'next_text'    => __('<li>next >></li>'),
                        ));
                    }
                ?>
            </ul>
        </div>
    </div>
</div>
<!-- pagination end -->



<?php get_footer() ?>