<?php 
function my_script_enqueue(){
	
	wp_enqueue_style ('theme-style', get_template_directory_uri().'/css/home.css',array(),'1.0.0','all');
	wp_enqueue_style ('menus', get_template_directory_uri().'/css/menu.css', array());
	wp_enqueue_style ('reset', get_template_directory_uri().'/css/reset.css', array('theme-style'));
	wp_enqueue_style ('form', get_template_directory_uri().'/form.css', array());

    // ✅ JS Files
    wp_enqueue_script('menu-script', get_template_directory_uri() . '/menu-script.js', array(), '1.0.0', true);
	
}

add_action('wp_enqueue_scripts', 'my_script_enqueue');

function menu_script_enqueue()
{
	add_theme_support("menus");
	register_nav_menu('Primary1' , 'primary header menu1');
	register_nav_menu('Primary2' , 'footer menu1');
	register_nav_menu('Primary3' , 'footer menu2');
	
}

add_action('init','menu_script_enqueue');


//To Call featured image 
add_theme_support('post-thumbnails');

//
add_theme_support('custom-header');


add_filter('nav_menu_css_class' , 'special_nav_class' , 10 , 2);

function special_nav_class ($classes, $item) {
    if (in_array('current-menu-item', $classes) ){
        $classes[] = 'active';
    }
    return $classes;
}



$banner  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'banner',
	'category_name'    => 'banner',
	'orderby'          => 'date',
	'order'            => 'ASC',
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $banner);


$product_categories  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'product_categories',
	'category_name'    => 'product_categories',
	'orderby'          => 'date',
	'order'            => 'ASC',
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $product_categories);



$why_choose_us  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'why_choose_us',
	'category_name'    => 'why_choose_us',
	'orderby'          => 'date',
	'order'            => 'ASC',
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $why_choose_us);


$certifications  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'certifications',
	'category_name'    => 'certifications',
	'orderby'          => 'date',
	'order'            => 'ASC',
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $certifications);


$core_product  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'core_product',
	'category_name'    => 'core_product',
    'orderby'          => 'title',  // ✅ Change here
	'order'            => 'ASC',
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $core_product);


$certifications  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'certifications',
	'category_name'    => 'certifications',
	'orderby'          => 'date',
	'order'            => 'ASC',    // A-Z
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $certifications);


$strength  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'strength',
	'category_name'    => 'strength',
	'orderby'          => 'date',
	'order'            => 'ASC',
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $strength);


$herbal_extracts  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'herbal_extracts',
	'category_name'    => 'herbal_extracts',
    'orderby'          => 'title',  // ✅ Change here
    'order'            => 'ASC',    // A-Z
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $herbal_extracts);


$essential_oils  = array(
	'posts_per_page'   => 500,
	'offset'           => 0,
	'category'         => 'essential_oils',
	'category_name'    => 'essential_oils',
    'orderby'          => 'title',  // ✅ Change here
    'order'            => 'ASC',    // A-Z
	'include'          => '',
	'exclude'          => '',
	'meta_key'         => '',
	'meta_value'       => '',
	'post_type'        => 'post',
	'post_mime_type'   => '',
	'post_parent'      => '',
	'author'	   => '',
	'post_status'      => 'publish',
	'suppress_filters' => true 
	
);


$posts_array = get_posts( $essential_oils);


$herbal_powders  = array(
    'posts_per_page'   => 500,
    'offset'           => 0,
    'category'         => 'herbal_powders',
    'category_name'    => 'herbal_powders',
    'orderby'          => 'title',  // ✅ Change here
    'order'            => 'ASC',    // A-Z
    'include'          => '',
    'exclude'          => '',
    'meta_key'         => '',
    'meta_value'       => '',
    'post_type'        => 'post',
    'post_mime_type'   => '',
    'post_parent'      => '',
    'author'           => '',
    'post_status'      => 'publish',
    'suppress_filters' => true 
);

$posts_array = get_posts( $herbal_powders );


$sustainability  = array(
    'posts_per_page'   => 500,
    'offset'           => 0,
    'category'         => 'sustainability',
    'category_name'    => 'sustainability',
	'orderby'          => 'date',
	'order'            => 'ASC',
    'include'          => '',
    'exclude'          => '',
    'meta_key'         => '',
    'meta_value'       => '',
    'post_type'        => 'post',
    'post_mime_type'   => '',
    'post_parent'      => '',
    'author'           => '',
    'post_status'      => 'publish',
    'suppress_filters' => true 
);

$posts_array = get_posts( $sustainability );



function remove_img_size_attributes($html) {
    return preg_replace('/(width|height)="\d*"\s/', '', $html);
}
add_filter('post_thumbnail_html', 'remove_img_size_attributes');


class Custom_Walker_Nav_Menu extends Walker_Nav_Menu {
    // Add class to <ul> submenus
    function start_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        
        // Apply class only to submenu levels
        $submenu_class = ($depth >= 0) ? 'three-column-submenu' : '';
        
        $output .= "\n$indent<ul class=\"" . esc_attr($submenu_class) . "\">\n";
    }
}



function dual_logo_customize_register($wp_customize) {
    // Secondary Logo
    $wp_customize->add_setting('secondary_logo');
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        'secondary_logo',
        array(
            'label' => 'Secondary Logo (Scrolled Header)',
            'section' => 'title_tagline',
            'settings' => 'secondary_logo'
        )
    ));
}
add_action('customize_register', 'dual_logo_customize_register');



function wordpress_numeric_post_nav() {
    if( is_singular() )
        return;
    global $wp_query;
    /* Stop the code if there is only a single page page */
    if( $wp_query->max_num_pages <= 1 )
        return;
    $paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
    $max   = intval( $wp_query->max_num_pages );
    /*Add current page into the array */
    if ( $paged >= 1 )
        $links[] = $paged;
    /*Add the pages around the current page to the array */
    if ( $paged >= 3 ) {
        $links[] = $paged - 1;
        $links[] = $paged - 2;
    }
    if ( ( $paged + 2 ) <= $max ) {
        $links[] = $paged + 2;
        $links[] = $paged + 1;
    }
    echo '<div class="navigation"><ul>' . "\n";
    /*Display Previous Post Link */
    if ( get_previous_posts_link() )
        printf( '<li>%s</li>' . "\n", get_previous_posts_link() );
    /*Display Link to first page*/
    if ( ! in_array( 1, $links ) ) {
        $class = 1 == $paged ? ' class="active"' : '';
        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( 1 ) ), '1' );
        if ( ! in_array( 2, $links ) )
            echo '<li>�</li>';
    }
    /* Link to current page */
    sort( $links );
    foreach ( (array) $links as $link ) {
        $class = $paged == $link ? ' class="active"' : '';
        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
    }
    /* Link to last page, plus ellipses if necessary */
    if ( ! in_array( $max, $links ) ) {
        if ( ! in_array( $max - 1, $links ) )
            echo '<li>�</li>' . "\n";
        $class = $paged == $max ? ' class="active"' : '';
        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $max ) ), $max );
    }
    /** Next Post Link */
    if ( get_next_posts_link() )
        printf( '<li>%s</li>' . "\n", get_next_posts_link() );
    echo '</ul></div>' . "\n";
}