<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Include PHPMailer
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get form data
    $name = htmlspecialchars($_POST['name']);
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $phone = htmlspecialchars($_POST['phone']);
    $service = htmlspecialchars($_POST['service']); // Fetch the selected service
    $message = htmlspecialchars($_POST['message']);

    // Validate email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die('Invalid email format');
    }

    // Admin & SMTP Credentials
    $adminEmail = 'umar.nucleosys@gmail.com';  // Admin email
    $smtpUsername = 'pn71900@gmail.com';  
    $smtpPassword = 'NucleosysTech1322024';  

    // PHPMailer Setup
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = $smtpUsername;
        $mail->Password = $smtpPassword;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        // ======= (1) Send Email to Admin =======
        $mail->setFrom($smtpUsername, 'Service Inquiry'); 
        $mail->addAddress($adminEmail);
        $mail->addReplyTo($email, $name);

        $mail->Subject = 'New Inquiry from Website';
        $mail->isHTML(true);
        $mail->Body = "
            <h3>New Inquiry Details:</h3>
            <strong>Name:</strong> {$name} <br>
            <strong>Email:</strong> {$email} <br>
            <strong>Phone:</strong> {$phone} <br>
            <strong>Service:</strong> {$service} <br>
            <strong>Message:</strong> {$message} <br>
        ";
        $mail->send();

        // ======= (2) Send Personalized Confirmation Email to User =======
        $mail->clearAddresses();  
        $mail->addAddress($email);  
        $mail->setFrom($smtpUsername, 'enquiry@nucleosystech.in');
        $mail->Subject = 'Thank You for Reaching Out!';

        // Email Body with Better Formatting
        $mail->Body = "
            <p>Dear {$name},</p>
            
            <p>Thank you for getting in touch with us! We have received your inquiry regarding <strong>{$service}</strong>, and our team will review your request shortly.</p>
            
            <p>Here’s what happens next:</p>
            <ul>
                <li>Our team will assess your requirements.</li>
                <li>We will contact you soon at <strong>{$phone}</strong>.</li>
                <li>Expect a response within 24-48 hours.</li>
            </ul>

            <p>If you need immediate assistance, feel free to call us or reply to this email.</p>

            <p>Best regards,</p>
            <p><strong>ieNucleosys Techno Pvt. Ltd.</strong><br>
            📧 enquiry@nucleosystech.in<br>
            📞 +91 88660 64848</p>
        ";

        $mail->send();

        // ======= Redirect to Thank You Page =======
        echo "<script>window.location.href='thankyou.html';</script>";
        exit();
    } catch (Exception $e) {
        echo "Error: {$mail->ErrorInfo}";
    }
} else {
    die("Invalid Request");
}

?>
