<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	add_filter('gdlr_core_use_font_icons', 'traveltour_gdlr_core_use_font_icons');
	if( !function_exists('traveltour_gdlr_core_use_font_icons') ){
		function traveltour_gdlr_core_use_font_icons( $icons ){
			return traveltour_get_option('plugin', 'font-icon', $icons);
		}
	} 
	
	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'traveltour_page_builder_body_class');
	if( !function_exists('traveltour_page_builder_body_class') ){
		function traveltour_page_builder_body_class( $classes ) {
			return $classes . ' traveltour-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'traveltour_gdlr_core_sidebar_class');
	if( !function_exists('traveltour_gdlr_core_sidebar_class') ){
		function traveltour_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' traveltour-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'traveltour_goodlayers_core_setup');
	if( !function_exists( 'traveltour_goodlayers_core_setup' ) ){
		function traveltour_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'traveltour_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'traveltour_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'traveltour_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'traveltour_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'traveltour_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'traveltour_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_related', 'traveltour_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'traveltour_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'traveltour_gdlr_core_portfolio_hover_icon_class');

			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'traveltour_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('traveltour_gdlr_core_privacy_settings') ){
		function traveltour_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = traveltour_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}


	// portfolio hover icon class
	if( !function_exists('traveltour_gdlr_core_portfolio_hover_icon_class') ){
		function traveltour_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return traveltour_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return traveltour_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return traveltour_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('traveltour_gdlr_core_enable_srcset') ){
		function traveltour_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = traveltour_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}
			
	// for goodlayers core pagination
	if( !function_exists('traveltour_gdlr_core_pagination_style') ){
		function traveltour_gdlr_core_pagination_style( $style ) {
			return traveltour_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('traveltour_gdlr_core_pagination_align') ){
		function traveltour_gdlr_core_pagination_align( $align ) {
			return traveltour_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('traveltour_gdlr_core_custom_post_slug') ){
		function traveltour_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = traveltour_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = traveltour_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = traveltour_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = traveltour_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = traveltour_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('traveltour_gdlr_core_portfolio_single_nav') ){
		function traveltour_gdlr_core_portfolio_single_nav( $check ) {
			return traveltour_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('traveltour_gdlr_core_portfolio_single_related') ){
		function traveltour_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = traveltour_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = traveltour_get_option('general', 'related-portfolio-style', 'grid');
				$args['num-fetch'] = traveltour_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['thumbnail-size'] = traveltour_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['excerpt-number'] = traveltour_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['column-size'] = traveltour_get_option('general', 'related-portfolio-column-size', 15);

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('traveltour_gdlr_core_social_share_list') ){
		function traveltour_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = traveltour_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = traveltour_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['pinterest'] = traveltour_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = traveltour_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = traveltour_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = traveltour_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'traveltour_register_custom_uploaded_font');
	if( !function_exists('traveltour_register_custom_uploaded_font') ){
		function traveltour_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = traveltour_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$font_option['name'] = str_replace('+', '', $font_option['name']);
					while( !empty($custom_fonts[$font_option['name']]) ){
						$font_option['name'] = $font_option['name'] . '+';
					}

					$custom_fonts[$font_option['name']] = array(
						'eot' => empty($font_option['eot'])? '': $font_option['eot'],
						'ttf' => empty($font_option['ttf'])? '': $font_option['ttf'],
						'woff' => empty($font_option['woff'])? '': $font_option['woff'],
						'font-weight' => empty($font_option['font-weight'])? 'normal': $font_option['font-weight'],
						'font-style' => empty($font_option['font-style'])? 'normal': $font_option['font-style']
					);
				}
			}			
			
			return $custom_fonts;
			
		} // traveltour_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('traveltour_gdlr_core_widget_title_nav') ){
		function traveltour_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'traveltour_gdlr_core_page_builder_post_type');
	if( !function_exists('traveltour_gdlr_core_page_builder_post_type') ){
		function traveltour_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'traveltour_gdlr_core_lightbox_type');
	if( !function_exists('traveltour_gdlr_core_lightbox_type') ){
		function traveltour_gdlr_core_lightbox_type(){
			$lightbox_type = traveltour_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = traveltour_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'traveltour_lightbox_body_class');
	if( !function_exists('traveltour_lightbox_body_class') ){
		function traveltour_lightbox_body_class($class){
			$link_to_lightbox = traveltour_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'traveltour_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'traveltour_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('traveltour_gdlr_core_page_builder_page_template_list') ){
		function traveltour_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['home-1'] = array(
				'title' => esc_html__('Home - 1', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-2'] = array(
				'title' => esc_html__('Home - 2', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-3'] = array(
				'title' => esc_html__('Home - 3', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-4'] = array(
				'title' => esc_html__('Home - 4', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-citytour'] = array(
				'title' => esc_html__('Home - City Tour', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-yachttour'] = array(
				'title' => esc_html__('Home - Yacht Tour', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-main4'] = array(
				'title' => esc_html__('Home - Main 4', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-hiking'] = array(
				'title' => esc_html__('Home - Hiking', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-golf'] = array(
				'title' => esc_html__('Home - Golf', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-museum'] = array(
				'title' => esc_html__('Home - Museum', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['home-winery'] = array(
				'title' => esc_html__('Home - Winery', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['about-us'] = array(
				'title' => esc_html__('About Us', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['about-us2'] = array(
				'title' => esc_html__('About Us 2', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['about-us3'] = array(
				'title' => esc_html__('About Us 3', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['about-our-team'] = array(
				'title' => esc_html__('About Our Team', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['our-services'] = array(
				'title' => esc_html__('Our Services', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['contact'] = array(
				'title' => esc_html__('Contact', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['contact2'] = array(
				'title' => esc_html__('Contact 2', 'traveltour'),
				'type' => 'wrapper',
			);
			$templates['contact3'] = array(
				'title' => esc_html__('Contact 3', 'traveltour'),
				'type' => 'wrapper',
			);
			return $templates;
		} // traveltour_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('traveltour_gdlr_core_page_builder_get_page_template') ){
		function traveltour_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'home-1': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4653","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Column Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4654","title":"500+ Destinations","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4655","title":"Best Price Guarantee","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4656","title":"Great Customer","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4657","title":"Super Fast Booking","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4661","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"52px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Search"},"items":[{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"","fields":["keywords","location","duration","date"],"style":"column","with-frame":"disable","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4663","background-image-style":"repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Homepage Search"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular Tour Packages","caption":"","caption-position":"top","title-width":"300px","title-link-text":"View All Tours","title-link":"http://demo.goodlayers.com/traveltour/tour-side-thumbnail-with-frame-right-sidebar/","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"29px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"55px"}},{"template":"element","type":"tour","value":{"id":"","class":"","category":null,"tag":null,"num-fetch":"8","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","column-size":"20","thumbnail-size":"Portfolio Thumbnail","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"right-title","tour-info":["duration-text"],"excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"","tour-title-font-weight":"","tour-title-letter-spacing":"","tour-title-text-transform":"uppercase","padding-bottom":"0px","tour-title-bottom-margin":"","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular Destinations","caption":"","caption-position":"top","title-link-text":"View All Destinations","title-link":"http://demo.goodlayers.com/traveltour/destinations/","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_pin_alt","left-image":"","heading-tag":"h3","icon-font-size":"29px","title-font-size":"29px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"20px"}},{"template":"wrapper","type":"column","column":"45","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Etiam porta sem malesuada magna mollis euismod. Maecenas sed diam eget risus varius blandit sit amet non magna. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","text-align":"left","font-size":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour_category","value":{"id":"","class":"","category":["africa","america","asia","europe","south-america"],"num-fetch":"5","orderby":"name","order":"desc","style":"grid","column-size":"12","thumbnail-size":"Tour Category","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"36","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Browse Tours By Category","caption":"","caption-position":"top","title-width":"300px","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-sliders","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"24px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"19px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}}]},{"template":"wrapper","type":"column","column":"24","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Newsletter","caption":"","caption-position":"top","title-width":"300px","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-envelope-o","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"24px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"19px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"23px"}}]},{"template":"wrapper","type":"column","column":"36","items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"","icon-hover":"","title":"Outdoor Activites","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/outdoor-activites/","link-target":"_self"},{"icon":"","icon-hover":"","title":"City Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/city-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Cultural & Thematic Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/cultural-thematic-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Indulgence & Luxury Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/indulgence-luxury-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Family Friendly Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/family-friendly-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Relaxation Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/relaxation-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Holiday & Seasonal Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/holiday-seasonal-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Wild & Adventure Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/wild-adventure-tours/","link-target":"_self"}],"columns":"30","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"14px","content-size":"15px","list-bottom-margin":"13px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Newsletter form"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Subscribe for updates & promotions","text-align":"left","font-size":"","padding-bottom":"0px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"round","padding-bottom":"25px"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"#","pinterest":"#","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"left","icon-size":"18px","with-text":"disable","text-size":"15px","icon-color":"#aaaaaa","icon-space":"20px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4664","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Discount <span style=\"color: #ffb43e;\">10-30% Off</span>","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"48px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Curabitur blandit tempus porttitor. Curabitur blandit tempus porttitor. Maecenas faucibus mollis interdum. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit.","text-align":"left","font-size":"15px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Promotion Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://demo.goodlayers.com/traveltour/popular-deals/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#424242","text-hover-color":"#468fe7","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Travel Articles","caption":"","caption-position":"top","title-width":"300px","title-link-text":"Read All Articles","title-link":"http://demo.goodlayers.com/traveltour/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_lightbulb_alt","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"24px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"19px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"4","prepend-sticky":"disable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-image","blog-full-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"disable","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","blog-title-font-size":"15px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","padding-bottom":"25px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4653","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Column Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"left","background-color":"#4263c1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"56px","right":"0px","bottom":"56px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"17px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Blue Icon"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Book With Us?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"19px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4665","title":"40,000+ Customers","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4666","title":"Award Winning","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4667","title":"Secure Payment","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]}]';
				case 'home-2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"4653","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4670","title":"500+ Destinations","caption":"","content":"Nullam quis risus eget urna mollis ornare vel eu leo. Nullam id.","read-more-text":"Read More","read-more-link":"","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4655","title":"Best Price In The Industry","caption":"","content":"Nullam quis risus eget urna mollis ornare vel eu leo. Nullam id.","read-more-text":"Read More","read-more-link":"","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"28px","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4671","title":"Great Customer Support","caption":"","content":"Nullam quis risus eget urna mollis ornare vel eu leo. Nullam id.","read-more-text":"Read More","read-more-link":"","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4657","title":"Super Fast Booking","caption":"","content":"Nullam quis risus eget urna mollis ornare vel eu leo. Nullam id.","read-more-text":"Read More","read-more-link":"","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"35px","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Tour Packages","caption":"","caption-position":"top","title-link-text":" View All Tours","title-link":"#","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_pin_alt","left-image":"","heading-tag":"h3","icon-font-size":"29px","title-font-size":"29px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Etiam porta sem malesuada magna mollis euismod. Maecenas sed diam eget risus varius blandit sit amet non magna. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","text-align":"left","font-size":"","padding-bottom":"34px"}},{"template":"element","type":"tour","value":{"id":"","class":"","category":null,"tag":null,"num-fetch":"4","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"load-more","pagination-style":"default","pagination-align":"default","tour-style":"medium-with-frame","column-size":"20","thumbnail-size":"Tour Side Thumbnail","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"right-title","tour-info":["duration-text","availability"],"excerpt":"specify-number","excerpt-number":"13","tour-rating":"enable","tour-title-font-size":"","tour-title-font-weight":"","tour-title-letter-spacing":"","tour-title-text-transform":"uppercase","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"Search Tour","fields":["keywords","location","duration","date","min-price","max-price"],"style":"full","with-frame":"image","frame-background-color":"","frame-background-image":"4842","padding-bottom":"70px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Reviews","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-commenting-o","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"19px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"38px"}},{"template":"element","type":"tour_review","value":{"id":"","class":"","num-display":"4","padding-bottom":"37px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Newsletter","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-envelope-o","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"19px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"35px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle-full","padding-bottom":"25px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4672","background-image-style":"repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Column Service"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular Destinations","caption":"","caption-position":"bottom","title-link-text":"View All Destinations","title-link":"http://demo.goodlayers.com/traveltour/destinations/","title-link-target":"_self","text-align":"center","left-media-type":"icon","left-icon":"icon_pin_alt","left-image":"","heading-tag":"h3","icon-font-size":"29px","title-font-size":"29px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#d6d6d6","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"20px"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"750px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Etiam porta sem malesuada magna mollis euismod. Maecenas sed diam eget risus varius blandit sit amet non magna. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","text-align":"center","font-size":"","padding-bottom":"45px"}}]},{"template":"element","type":"tour_category","value":{"id":"","class":"","category":["africa","america","asia","europe","south-america"],"num-fetch":"5","orderby":"name","order":"desc","style":"grid","column-size":"12","thumbnail-size":"Tour Category","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"one-third-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Featured Video","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-film","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"38px"}},{"template":"element","type":"video","value":{"id":"","class":"","video-type":"vimeo","video-url":"https://vimeo.com/80857342","video-url-mp4":"","video-url-webm":"","video-url-ogg":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Travelling in Hawaii","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"16px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#467fe7","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Etiam porta sem malesuada magna mollis euismod. Maecenas sed diam eget risus.","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"one-third-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Travel Articles","caption":"","caption-position":"top","title-link-text":"All Articles","title-link":"http://demo.goodlayers.com/traveltour/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_lightbulb_alt","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"38px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"4","prepend-sticky":"disable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-widget","blog-full-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"disable","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","blog-title-font-size":"15px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","padding-bottom":"10px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"one-third-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"right","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"38px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Browse By Category","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-sliders","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"32px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"","icon-hover":"","title":"Outdoor Activites","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/outdoor-activites/","link-target":"_self"},{"icon":"","icon-hover":"","title":"City Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/city-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Cultural & Thematic Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/cultural-thematic-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Indulgence & Luxury Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/indulgence-luxury-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Family Friendly Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/family-friendly-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Relaxation Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/relaxation-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Holiday & Seasonal Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/holiday-seasonal-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Wild & Adventure Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/wild-adventure-tours/","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"14px","content-size":"15px","list-bottom-margin":"13px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4653","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Column Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"left","background-color":"#4263c1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"56px","right":"0px","bottom":"56px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"17px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Blue Icon"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Book With Us?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"19px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4665","title":"40,000+ Customers","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4666","title":"Award Winning","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4667","title":"Secure Payment","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]}]';
				case 'home-3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4661","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"52px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Search"},"items":[{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"","fields":["keywords","location","duration","date"],"style":"column","with-frame":"disable","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"65px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blog HP3"},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","category":null,"tag":["popular-deals"],"num-fetch":"8","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","column-size":"30","thumbnail-size":"Blog Column Thumbnail","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation","price-position":"bottom-bar","tour-info":["duration-text"],"excerpt":"specify-number","excerpt-number":"20","tour-rating":"enable","tour-title-font-size":"","tour-title-font-weight":"","tour-title-letter-spacing":"","tour-title-text-transform":"uppercase","padding-bottom":"60px","tour-title-bottom-margin":"","title-align":"left","title-left-icon":"icon_tags_alt","title":"Popular Deals","caption":"","read-more-text":" View All Promotions","read-more-link":"http://demo.goodlayers.com/traveltour/popular-deals/","read-more-target":"_self","title-size":"23px","caption-size":"16px","read-more-size":"14px","title-left-icon-color":"#465dd1","title-color":"","caption-color":"","read-more-color":"#465dd1","read-more-divider-color":""}},{"template":"element","type":"tour","value":{"id":"","class":"","category":null,"tag":["top-vacation-tours"],"num-fetch":"8","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","column-size":"30","thumbnail-size":"Blog Column Thumbnail","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation","price-position":"bottom-bar","tour-info":["duration-text"],"excerpt":"specify-number","excerpt-number":"20","tour-rating":"enable","tour-title-font-size":"","tour-title-font-weight":"","tour-title-letter-spacing":"","tour-title-text-transform":"uppercase","padding-bottom":"60px","tour-title-bottom-margin":"","title-align":"left","title-left-icon":"fa fa-thumbs-o-up","title":"Top Vacation Tours","caption":"","read-more-text":" View All Tours","read-more-link":"http://demo.goodlayers.com/traveltour/top-vacation-tours/","read-more-target":"_self","title-size":"23px","caption-size":"16px","read-more-size":"14px","title-left-icon-color":"#465dd1","title-color":"","caption-color":"","read-more-color":"#465dd1","read-more-divider-color":""}},{"template":"element","type":"tour","value":{"id":"","class":"","category":null,"tag":["top-one-day-tour"],"num-fetch":"8","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","column-size":"30","thumbnail-size":"Blog Column Thumbnail","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation","price-position":"bottom-bar","tour-info":["duration-text"],"excerpt":"specify-number","excerpt-number":"20","tour-rating":"enable","tour-title-font-size":"","tour-title-font-weight":"","tour-title-letter-spacing":"","tour-title-text-transform":"uppercase","padding-bottom":"60px","tour-title-bottom-margin":"","title-align":"left","title-left-icon":"fa fa-clock-o","title":"Top One Day Tour ","caption":"","read-more-text":" View All One Day Tours","read-more-link":"http://demo.goodlayers.com/traveltour/one-day-tours/","read-more-target":"_self","title-size":"23px","caption-size":"16px","read-more-size":"14px","title-left-icon-color":"#465dd1","title-color":"","caption-color":"","read-more-color":"#465dd1","read-more-divider-color":""}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Newsletter form HP3"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Latest Travel Tours","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_volume-high_alt","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"19px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"45px"}},{"template":"element","type":"tour","value":{"id":"","class":"","category":null,"tag":null,"num-fetch":"5","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"widget","column-size":"20","thumbnail-size":"full","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"right-title","tour-info":null,"excerpt":"specify-number","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"","tour-title-font-weight":"","tour-title-letter-spacing":"","tour-title-text-transform":"uppercase","padding-bottom":"55px","tour-title-bottom-margin":"","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Featured Destinations","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_star_alt","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"19px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"40px"}},{"template":"element","type":"tour_category","value":{"id":"","class":"","category":"","num-fetch":"9","orderby":"name","order":"desc","style":"widget","column-size":"20","thumbnail-size":"Personnel Square","padding-bottom":"45px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Browse Tours By Category","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-sliders","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"19px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"32px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"","icon-hover":"","title":"Outdoor Activites","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/outdoor-activites/","link-target":"_self"},{"icon":"","icon-hover":"","title":"City Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/city-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Cultural & Thematic Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/cultural-thematic-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Indulgence & Luxury Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/indulgence-luxury-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Family Friendly Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/family-friendly-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Relaxation Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/relaxation-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Holiday & Seasonal Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/holiday-seasonal-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Wild & Adventure Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/wild-adventure-tours/","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"14px","content-size":"15px","list-bottom-margin":"13px","padding-bottom":"30px"}},{"template":"element","type":"feature-box","value":{"id":"","class":"","media-type":"icon","icon":"","image":"","title":"Get a Question?","caption":"Do not hesitage to give us a call. We are an expert team and we are happy to talk to you.","content":"<p>[gdlr_core_icon icon=\"fa fa-phone\" size=\"21px\" color=\"#ffcf2a\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"font-size: 20px; color: #ffcf2a; font-weight: 600;\">1.8445.3356.33</span><br />\n[gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"21px\" color=\"#ffcf2a\" margin-left=\"\" margin-right=\"10px\" ] <span style=\"font-size: 14px; color: #fff; font-weight: 600;\">Help@tourmasterwp.com</span></p>\n","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"left","icon-size":"35px","title-size":"20px","title-font-weight":"700","caption-size":"13px","content-size":"13px","icon-color":"","title-color":"","caption-color":"","content-color":"","background-color":"","border-color":"","sync-height":"","centering-sync-height-content":"disable","background-image":"4924","background-opacity":"0","border-type":"none","border-width":{"top":"5px","right":"5px","bottom":"5px","left":"5px","settings":"link"},"border-radius":"3px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"content-padding":{"top":"50px","right":"35px","bottom":"30px","left":"35px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Newsletter","caption":"","caption-position":"top","title-width":"300px","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-envelope-o","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"19px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"19px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"23px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle-full","padding-bottom":"25px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"830px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4681","background-image-style":"repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Testimonial"},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Customer Reviews","title-left-icon":"fa fa-comments-o","caption":"","tabs":[{"title":"John Smith","position":"Solo Traveller","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Cras justo odio, dapibus ac facilisis in, egestas eget quam.","image":"4108","image-img":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2016/05/personnel-2.jpg","rating":"10"},{"title":"Jennifer Sandler","position":"Couple Traveller","content":"Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Nullam id dolor id nibh ultricies vehicula ut id elit. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec sed odio dui.","image":"4904","image-img":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2017/01/photo-1428931996691-a5108d4cdbf5.jpg","rating":"9"},{"title":"Laura Linth","position":"Solo Traveller","content":"Cras justo odio, dapibus ac facilisis in, egestas eget quam. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam quis risus eget urna mollis ornare vel eu leo. Vivamus sagittis lacus vel augue laoreet rutrum.","image":"4905","image-img":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2017/01/TNK87N7464.jpg","rating":"8"}],"style":"center","column":"1","enable-quote":"disable","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"bullet","title-size":"28px","title-text-transform":"uppercase","title-letter-spacing":"","caption-size":"16px","content-size":"15px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4653","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Column Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4665","title":"40,000+ Customers","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4666","title":"Award Winning","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4667","title":"Secure Payment","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4680","title":"Many Great Deals","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]}]';
				case 'home-4': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"4653","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4670","title":"500+ Destinations","caption":"","content":"Nullam quis risus eget urna mollis ornare vel eu leo. Nullam id.","read-more-text":"Read More","read-more-link":"","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4655","title":"Best Price In The Industry","caption":"","content":"Nullam quis risus eget urna mollis ornare vel eu leo. Nullam id.","read-more-text":"Read More","read-more-link":"","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"28px","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4671","title":"Great Customer Support","caption":"","content":"Nullam quis risus eget urna mollis ornare vel eu leo. Nullam id.","read-more-text":"Read More","read-more-link":"","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4657","title":"Super Fast Booking","caption":"","content":"Nullam quis risus eget urna mollis ornare vel eu leo. Nullam id.","read-more-text":"Read More","read-more-link":"","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"35px","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4686","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Search HP4"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Search Tours","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"icon","left-icon":"icon_search","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"35px"}},{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"","fields":["keywords","location","duration","date"],"style":"column","with-frame":"disable","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"4687","background-image-style":"repeat-x","background-image-position":"bottom-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Top Destinations","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"icon","left-icon":"icon_pin_alt","left-image":"","heading-tag":"h3","icon-font-size":"26px","title-font-size":"29px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<a href=\"http://demo.goodlayers.com/traveltour/destinations/\">View All Destinations</a>","text-align":"center","font-size":"","padding-bottom":"35px"}},{"template":"element","type":"tour_category","value":{"id":"","class":"","category":["africa","asia","europe","south-america"],"num-fetch":"4","orderby":"name","order":"desc","style":"grid","column-size":"15","thumbnail-size":"Tour Category","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4688","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.05","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular Tour Packages","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"icon","left-icon":"icon_pin_alt","left-image":"","heading-tag":"h3","icon-font-size":"27px","title-font-size":"29px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#5886e9","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<a href=\"http://demo.goodlayers.com/traveltour/tour-side-thumbnail-with-frame-right-sidebar/\">View All Tours</a>","text-align":"center","font-size":"","padding-bottom":"35px"}},{"template":"element","type":"tour","value":{"id":"","class":"","category":"","tag":"","num-fetch":"8","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","column-size":"20","thumbnail-size":"Portfolio Thumbnail","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"right-title","tour-info":["duration-text"],"excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"","tour-title-font-weight":"","tour-title-letter-spacing":"","tour-title-text-transform":"uppercase","padding-bottom":"0px","tour-title-bottom-margin":"","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Browse Tours By Category","caption":"","caption-position":"top","title-width":"300px","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"icon","left-icon":"fa fa-sliders","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"29px","title-font-size":"29px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"19px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"","icon-hover":"","title":"Outdoor Activites","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/outdoor-activites/","link-target":"_self"},{"icon":"","icon-hover":"","title":"City Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/city-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Cultural & Thematic Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/cultural-thematic-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Indulgence & Luxury Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/indulgence-luxury-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Family Friendly Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/family-friendly-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Relaxation Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/relaxation-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Holiday & Seasonal Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/holiday-seasonal-tours/","link-target":"_self"},{"icon":"","icon-hover":"","title":"Wild & Adventure Tours","link-url":"http://demo.goodlayers.com/traveltour/tour-tag/wild-adventure-tours/","link-target":"_self"}],"columns":"15","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"14px","content-size":"15px","list-bottom-margin":"13px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4689","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Discount <span style=\"color: #ffb43e;\">10-30% Off</span>","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"48px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Curabitur blandit tempus porttitor. Curabitur blandit tempus porttitor. Maecenas faucibus mollis interdum. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit.","text-align":"left","font-size":"15px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Promotion Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://demo.goodlayers.com/traveltour/popular-deals/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#424242","text-hover-color":"#468fe7","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30"}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Featured Video","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-film","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"40px"}},{"template":"element","type":"video","value":{"id":"","class":"","video-type":"vimeo","video-url":"https://vimeo.com/80857342","video-url-mp4":"","video-url-webm":"","video-url-ogg":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Travelling in Hawaii","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"16px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#467fe7","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Vestibulum id ligula porta felis euismod semper. Curabitur blandit tempus porttitor. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Maecenas faucibus mollis interdum.","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Newsletter form"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Travel Articles","caption":"","caption-position":"top","title-link-text":"Read All Articles","title-link":"http://demo.goodlayers.com/traveltour/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_lightbulb_alt","left-image":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"40px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"3","prepend-sticky":"disable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-widget","blog-full-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"disable","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","blog-title-font-size":"15px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","padding-bottom":"35px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Newsletter","caption":"","caption-position":"top","title-width":"300px","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-envelope-o","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"19px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"19px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"round","padding-bottom":"25px"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"#","pinterest":"#","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"left","icon-size":"17px","with-text":"disable","text-size":"15px","icon-color":"#aaaaaa","icon-space":"18px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4653","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Column Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"left","background-color":"#4263c1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"57px","right":"0px","bottom":"57px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"17px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Blue Icon"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Book With Us?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"19px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4665","title":"40,000+ Customers","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4666","title":"Award Winning","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"column-service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Icon"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4667","title":"Secure Payment","caption":"","content":"Morbi leo risus, porta ac","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]}]';
				case 'home-citytour': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#303030","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"HP 1 Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5231","title":"Explore Things","caption":"","content":"<p>Parturient Magna</p>","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"18","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5232","title":"Attraction Tickets","caption":"","content":"<p>Justo Fringilla Sit</p>","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"18","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5233","title":"Transportation","caption":"","content":"<p>Ligula Euism Pharet</p>","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"18","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5234","title":"Museum Tickets","caption":"","content":"<p>Porta Ligula Justo</p>","read-more-text":"Read More","read-more-link":"","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"18","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Hp 1 Search"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Search For Tickets","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ea5318","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"43px"}},{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"","fields":["keywords","tour-activity","tour-destination","date"],"style":"column","enable-rating-field":"disable","filters":"","with-frame":"disable","frame-background-color":"","frame-background-image":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Browse By Activities","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"5237","heading-tag":"h3","icon-font-size":"18px","title-font-size":"32px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"19px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">View All Destination</a></p>","text-align":"center","font-size":"15px","padding-bottom":"45px"}},{"template":"element","type":"tour_category","value":{"id":"","class":"","filter-type":"tour-activity","category":"","tour_tag":"","tour-age":"","tour-activity":"","tour-destination":"","num-fetch":"8","orderby":"name","order":"asc","style":"grid-2","column-size":"15","thumbnail-size":"Tour Category","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f7f7f7","background-image":"4663","background-image-style":"repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","category":["popular-places"],"tag":"","tour-age":"","tour-activity":"","tour-destination":"","num-fetch":"8","orderby":"date","order":"desc","discount-status":"all","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","column-size":"20","thumbnail-size":"Portfolio Thumbnail","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"right-title","tour-info":"","excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"17px","tour-title-font-weight":"900","tour-title-letter-spacing":"0px","tour-title-text-transform":"uppercase","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"image","title-left-icon":"","title-left-image":"5246","title":"Popular Places","caption":"","caption-position":"top","read-more-text":"View All Places","read-more-link":"#","read-more-target":"_self","title-size":"26px","title-letter-spacing":"0px","title-font-style":"","title-text-transform":"none","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"#ea5318","read-more-divider-color":"","title-wrap-bottom-margin":"50px","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5247","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.13","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Hp 1 Why Us"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Booking With Us?","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"41px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ea5318","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Aenean eu leo quam. Pellentesque ornare sem lacinia.</p>","text-align":"left","font-size":"17px","padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_like","icon-hover":"","title":"All placges and activiates are carefully picked by us.","link-url":""},{"icon":"icon_currency","icon-hover":"","title":"Best price guaranteee & Hassle free!","link-url":""},{"icon":"icon_star_alt","icon-hover":"","title":"We are an award winning agency","link-url":""},{"icon":"icon_heart_alt","icon-hover":"","title":"Trusted by more than 80,000 customers","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ea5318","icon-background-color":"","content-color":"#425166","border-color":"","icon-size":"25px","content-size":"19px","list-bottom-margin":"20px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Find Out More!","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"18px","right":"34px","bottom":"18px","left":"34px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"15px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"4663","background-image-style":"repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","category":["trending-activities"],"tag":"","tour-age":"","tour-activity":"","tour-destination":"","num-fetch":"8","orderby":"date","order":"desc","discount-status":"all","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid","column-size":"15","thumbnail-size":"Portfolio Thumbnail","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"right-title","tour-info":"","excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"15px","tour-title-font-weight":"900","tour-title-letter-spacing":"0px","tour-title-text-transform":"uppercase","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"image","title-left-icon":"","title-left-image":"5251","title":"Trending Activities","caption":"","caption-position":"top","read-more-text":"View All Places","read-more-link":"#","read-more-target":"_self","title-size":"26px","title-letter-spacing":"0px","title-font-style":"","title-text-transform":"none","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"#ea5318","read-more-divider-color":"","title-wrap-bottom-margin":"50px","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f7f7f7","background-image":"4663","background-image-style":"repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","category":["transportation-deals"],"tag":"","tour-age":"","tour-activity":"","tour-destination":"","num-fetch":"8","orderby":"date","order":"desc","discount-status":"all","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid","column-size":"15","thumbnail-size":"Portfolio Thumbnail","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"right-title","tour-info":"","excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"15px","tour-title-font-weight":"900","tour-title-letter-spacing":"0px","tour-title-text-transform":"uppercase","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"image","title-left-icon":"","title-left-image":"5446","title":"Transportation Deals","caption":"","caption-position":"top","read-more-text":"View All Transportation","read-more-link":"#","read-more-target":"_self","title-size":"26px","title-letter-spacing":"0px","title-font-style":"","title-text-transform":"none","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"#ea5318","read-more-divider-color":"","title-wrap-bottom-margin":"50px","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"video","background-color":"","background-image":"5250","background-image-style":"cover","background-image-position":"center","background-video-url":"https://www.youtube.com/watch?v=eZjmjT5SLYs","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"140px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Travelling Highlights","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"55px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Your New Travelling Idea","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#24bef7","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"5252","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=eZjmjT5SLYs","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular Destinations","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-sliders","left-image":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"24px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"32px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Newsletter","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-envelope-o","left-image":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"24px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#ea5318","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"23px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"","icon-hover":"","title":"Marrakech","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/marrakech/"},{"icon":"","icon-hover":"","title":"New York","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/new-york/"},{"icon":"","icon-hover":"","title":"Tokyo","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/tokyo/"},{"icon":"","icon-hover":"","title":"Paris","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/paris/"},{"icon":"","icon-hover":"","title":"London","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/london/"},{"icon":"","icon-hover":"","title":"Rio de Janeiro","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/rio-de-janeiro/"},{"icon":"","icon-hover":"","title":"Madrid","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/madrid/"},{"icon":"","icon-hover":"","title":"Zurich","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/zurich/"},{"icon":"","icon-hover":"","title":"Osaka","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/osaka/"},{"icon":"","icon-hover":"","title":"Rome","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/rome/"},{"icon":"","icon-hover":"","title":"Bangkok","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/bangkok/"},{"icon":"","icon-hover":"","title":"Prague","link-url":"http://demo.goodlayers.com/traveltour/citytour/tour-destination/prague/"}],"columns":"20","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"14px","content-size":"15px","list-bottom-margin":"13px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Newsletter form"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Subscribe for updates & promotions","text-align":"left","font-size":"","padding-bottom":"0px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"round","padding-bottom":"25px"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"#","pinterest":"#","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"left","icon-size":"18px","with-text":"disable","text-size":"15px","icon-color":"#aaaaaa","icon-space":"20px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"830px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5253","background-image-style":"cover","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Testimonial"},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Customer Reviews","title-left-icon":"fa fa-comments-o","caption":"","tabs":[{"title":"John Smith","position":"Solo Traveller","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Cras justo odio, dapibus ac facilisis in, egestas eget quam.","image":"4108","image-img":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2016/05/personnel-2.jpg","rating":"10"},{"title":"Jennifer Sandler","position":"Couple Traveller","content":"Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Nullam id dolor id nibh ultricies vehicula ut id elit. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec sed odio dui.","image":"4904","image-img":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2017/01/photo-1428931996691-a5108d4cdbf5.jpg","rating":"9"},{"title":"Laura Linth","position":"Solo Traveller","content":"Cras justo odio, dapibus ac facilisis in, egestas eget quam. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam quis risus eget urna mollis ornare vel eu leo. Vivamus sagittis lacus vel augue laoreet rutrum.","image":"4905","image-img":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2017/01/TNK87N7464.jpg","rating":"8"}],"style":"center","column":"1","enable-quote":"disable","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"bullet","carousel-nav-style":"default","title-size":"28px","title-text-transform":"uppercase","title-letter-spacing":"","caption-size":"16px","content-size":"15px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"20px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We were featured in","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"none","left-icon":"fa fa-envelope-o","left-image":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"26px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#ea5318","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"56px","padding-bottom":"40px","icon-color":"","divider-color":"#ea5318"}},{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"5254","thumbnail":"http://demo.goodlayers.com/traveltour/citytour/wp-content/uploads/2016/06/banner-1-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5255","thumbnail":"http://demo.goodlayers.com/traveltour/citytour/wp-content/uploads/2016/06/banner-2-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5256","thumbnail":"http://demo.goodlayers.com/traveltour/citytour/wp-content/uploads/2016/06/banner-3-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5257","thumbnail":"http://demo.goodlayers.com/traveltour/citytour/wp-content/uploads/2016/06/banner-4-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5258","thumbnail":"http://demo.goodlayers.com/traveltour/citytour/wp-content/uploads/2016/06/banner-5-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]}]';
				case 'home-yachttour':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"2","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5232","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Yacht Column Service"},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5234","title":"Luxury Fleet","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of</p>","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"15px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5237","title":"Professional crews","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of</p>","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"15px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"","bottom":"33px","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5236","title":"Comfortable Bedroom","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of</p>","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"15px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5235","title":"Wifi on board","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of</p>","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"15px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"","bottom":"34px","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"105px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We provide the best yacht charter tour service","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#14274d","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-window-minimize","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"27px","margin-top":"","padding-bottom":"25px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#bea679"}},{"template":"element","type":"text-script","value":{"id":"","class":"","content":"We are a specialist the most popular destinations for yacht charters","text-align":"center","font-size":"18px","padding-bottom":"45px"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"930px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"yacht search form"},"items":[{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"","fields":["tour-destination","duration","month"],"style":"column","input-box-style":"no-border","enable-rating-field":"enable","filters":"","with-frame":"disable","frame-background-color":"","frame-background-image":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"service-half-1","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5239","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"service-half-1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"105px","right":"60px","bottom":"100px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Choose Us?","caption":"We are trusted by many customers","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"24px","caption-font-weight":"600","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#c3c3c3","title-link-hover-color":"","caption-color":"#253f72","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#aa9875","icon-color":"#aa9875","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"14px","text-font-weight":"700","text-letter-spacing":"1px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"service-half-2","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"85px","bottom":"105px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"10px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Make it the best","caption":"Unseen experience. Join Us!","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","caption-font-size":"24px","caption-font-weight":"600","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#c3c3c3","title-link-hover-color":"","caption-color":"#253f72","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Far far away, behind the word mountains","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"A small river named Duden flows by their place","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Question Marks and devious Semikoli, but ","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#7886a3","icon-background-color":"","content-color":"#7886a3","border-color":"","icon-size":"14px","content-size":"16px","icon-right-margin":"","list-bottom-margin":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"service-half-2","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#263b65","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5240","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.57","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"50px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5241","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=qS4Nn282A4M","page-id":"5230","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","category":["sailing-tour"],"tag":"","tour-age":"","tour-activity":"","tour-destination":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid","column-size":"20","thumbnail-size":"Blog Column Thumbnail","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"right-title","tour-info":["duration-text","availability"],"excerpt":"none","excerpt-number":"20","tour-rating":"disable","tour-title-font-size":"17px","tour-title-font-weight":"600","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"center","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"Luxury Yacht Tours","caption":"","caption-position":"bottom","read-more-text":"View All Tours","read-more-link":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search","read-more-target":"_self","title-size":"32px","title-letter-spacing":"","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-style":"normal","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"#aa9875","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"gdlr-core-round-style"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#5e5e5e","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5242","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"160px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"875px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Yacht Testimonial"},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Customer Reviews","title-left-icon":"fa fa-comments-o","caption":"","tabs":[{"title":"Jane Smith","position":"Coatia 5 days 4 nights","content":" I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a fewer stray gleams steal into the inner.","image":"5246","image-img":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/review-1.jpg","rating":""},{"title":"John Smith","position":"Tahiti  6 Nights","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense.","image":"5247","image-img":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/review-2.jpg","rating":""}],"style":"center","column":"1","thumbnail-size":"thumbnail","enable-quote":"disable","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-nav-style":"default","carousel-bullet-style":"default","title-size":"32px","title-text-transform":"uppercase","title-font-weight":"300","title-letter-spacing":"","caption-size":"16px","content-size":"18px","title-color":"#ffffff","caption-color":"","quote-color":"","content-color":"#97afd9","name-color":"#ffffff","position-color":"#ffffff","caption-spaces":"","title-wrap-bottom-margin":"35px","content-bottom-padding":"0px","padding-bottom":"3px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Yacht Counter"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5243","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"5230","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"1000    ","start-number":"","end-number":"","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Travellers Joined Us","top-icon-size":"30px","top-text-size":"18px","number-size":"46px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Yacht Counter"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5244","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"5230","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"40","start-number":"","end-number":"","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Perfect Routes","top-icon-size":"30px","top-text-size":"18px","number-size":"46px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Yacht Counter"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5234","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"5230","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"15","start-number":"","end-number":"","animation-time":"","suffix":"","divider":"disable","bottom-text":"Luxury Yachts","top-icon-size":"30px","top-text-size":"18px","number-size":"46px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Yacht Counter"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5245","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"5230","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"2500","start-number":"","end-number":"","animation-time":"","suffix":"","divider":"disable","bottom-text":"Days In Service","top-icon-size":"30px","top-text-size":"16px","number-size":"46px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","category":["private-charter"],"tag":"","tour-age":"","tour-activity":"","tour-destination":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid","column-size":"20","thumbnail-size":"Blog Column Thumbnail","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","price-position":"bottom-title-center","price-prefix-text":"Price Per Day","tour-info":"","excerpt":"none","excerpt-number":"20","tour-rating":"disable","tour-title-font-size":"17px","tour-title-font-weight":"600","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","padding-bottom":"100px","tour-title-bottom-margin":"","title-align":"center","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"Enquiry For Private Charter","caption":"","caption-position":"bottom","read-more-text":"View All Tours","read-more-link":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search","read-more-target":"_self","title-size":"32px","title-letter-spacing":"","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-style":"normal","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"#aa9875","read-more-divider-color":"","title-wrap-bottom-margin":"55px","title-carousel-nav-style":"gdlr-core-round-style"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":"Newsletter form"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Newsletter","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"fa fa-envelope-o","left-image":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"26px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#8c754b","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Subscribe for updates & promotions","text-align":"left","font-size":"","padding-bottom":"0px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"round","padding-bottom":"25px"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"#","pinterest":"#","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"left","icon-size":"18px","with-text":"disable","text-size":"15px","icon-color":"#aaaaaa","icon-space":"20px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular Destinations","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-sliders","left-image":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"26px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"35px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"","icon-hover":"","title":"Croatia","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=croatia"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Greece","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=greece"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Thailand","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=thailand"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Spain","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=spain"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Italy","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=italy"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Hawaii","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=hawaii"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Portsmouth","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=portsmouth"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Tahiti","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=tahiti"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Tonga","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=tonga"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Vancouver","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=vancouver"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Mediterranean","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=mediterranean"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Panama","caption":"","link-url":"https://demo.goodlayers.com/traveltour/yachttour/tour-search/?tour-search=&duration=&date=&min-price=&max-price=&rating=0&tour-destination%5B%5D=panama"}],"columns":"20","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","caption-color":"","border-color":"","icon-size":"14px","content-size":"15px","content-font-weight":"","content-text-transform":"","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f3f3f3","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Grey"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Gallery From Our Tours","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"31px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#101010","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"5263","thumbnail":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/shutterstock_361000748-150x150.jpg","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5272","thumbnail":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/shutterstock_523637050-150x150.jpg"},{"id":"5275","thumbnail":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/shutterstock_579064870-150x150.jpg"},{"id":"5240","thumbnail":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/shutterstock_371053961-150x150.jpg"},{"id":"5262","thumbnail":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/shutterstock_301077389-150x150.jpg"},{"id":"5270","thumbnail":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/shutterstock_473171722-150x150.jpg"},{"id":"5274","thumbnail":"https://demo.goodlayers.com/traveltour/yachttour/wp-content/uploads/2018/06/shutterstock_546950464-150x150.jpg"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation-round","carousel-bullet-style":"default","thumbnail-size":"Personnel Thumbnail","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5280","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Booking With Us?","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Aenean eu leo quam. Pellentesque ornare sem lacinia.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_like","icon-hover":"","title":"All placges and activiates are carefully picked by us.","caption":"","link-url":""},{"icon":"icon_currency","icon-hover":"","title":"Best price guaranteee & Hassle free!","caption":"","link-url":""},{"icon":"icon_star_alt","icon-hover":"","title":"We are an award winning agency","caption":"","link-url":""},{"icon":"icon_heart_alt","icon-hover":"","title":"Trusted by more than 5000 customers","caption":"","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ac9d81","icon-background-color":"","content-color":"#aebee8","caption-color":"","border-color":"","icon-size":"23px","content-size":"17px","content-font-weight":"","content-text-transform":"","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"18px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Find Out More!","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"13px","right":"27px","bottom":"13px","left":"27px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"14px","text-font-weight":"","text-letter-spacing":"","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]}]';
				case 'home-main4':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5223","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"165px","right":"0px","bottom":"165px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"orange"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Find Next Place To Visit","caption":"Discover amzaing places at exclusive deals","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"52px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"5px","media-margin-right":"15px","padding-bottom":"50px"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"900px","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"","fields":["keywords","tour-destination","duration"],"style":"column","input-size":"medium","item-style":"style-1","input-box-style":"no-border","enable-rating-field":"disable","filter-state":"disable","filters":"","with-frame":"disable","frame-background-color":"","frame-background-image":"","space-between-input":"2px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"1200px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"gradient","background-color":"#f97251","background-color-opacity":"1","background-gradient-color":"#ff986c","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"enable","container-background-color":"","container-background-gradient":"top","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":{"t-left":"","t-right":"","b-right":"","b-left":"","settings":"link"},"container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"3px","t-right":"3px","b-right":"3px","b-left":"3px","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"20px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"-40px","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5229","character":"","title":"700+ Destinations","caption":"","caption-position":"bottom","content":"<p>Our expert team handpicked all destinations in this site</p>","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"13px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5231","character":"","title":"Best Price Guarantee","caption":"","caption-position":"bottom","content":"<p>Price match within 48 hours of order confirmation</p>","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"13px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5232","character":"","title":"Top Notch support","caption":"","caption-position":"bottom","content":"<p>We are here to help, before, during, and even after your trip.</p>","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","icon-size":"30px","title-size":"13px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","caption-size":"15px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"10px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"73px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular Destinations","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin-right":"15px","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Destinations","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/traveltour/main4/destinations/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"8px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#e66836","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"400","text-letter-spacing":"0px","text-transform":"","icon-size":"17px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"52px"}},{"template":"element","type":"tour_category","value":{"id":"","class":"","filter-type":"tour-destination","category":"","tour_tag":"","tour-age":"","tour-activity":"","tour-destination":"","Price":"","num-fetch":"5","orderby":"name","order":"desc","style":"grid-3","column-size":"20","thumbnail-size":"Personnel Square","excerpt":"specify-number","excerpt-number":"25","with-feature":"enable","feature-thumbnail-size":"Tour Cat Featured","feature-excerpt":"specify-number","feature-excerpt-number":"25","border-radius":"3px","padding-bottom":"0px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5381","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular Tours","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Popular Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/traveltour/main4/tour-grid-3-columns/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"8px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#e66836","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"400","text-letter-spacing":"0px","text-transform":"","icon-size":"17px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"52px"}},{"template":"element","type":"tour","value":{"id":"","class":"","category":"","tag":["popular-deals"],"tour-age":"","tour-activity":"","tour-destination":"","Price":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","grid-style":"style-2","column-size":"20","thumbnail-size":"Personnel Thumbnail","enable-thumbnail-zoom-on-hover":"enable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation-outer","display-price":"enable","price-position":"right-title","price-prefix-text":"","tour-info":["duration-text"],"excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"18px","tour-title-font-weight":"800","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","frame-shadow-size":{"x":"","y":"","size":"23px","settings":"unlink"},"frame-shadow-color":"#0a0a0a","frame-shadow-opacity":"0.08","tour-border-radius":"3px","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"1220px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"gradient","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"sh1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"gradient","background-extending":"none","background-color":"#f97251","background-normal-color-opacity":"1","background-gradient-color":"#ff986c","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"3px","t-right":"0px","b-right":"0px","b-left":"3px","settings":"unlink"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"58px","right":"0px","bottom":"44px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Up to 40% Discount!","caption":"Enjoy Summer Deals","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"31px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"#fed7c8","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"9px","right":"24px","bottom":"11px","left":"24px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#1e354c","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"5251","thumbnail-size":"full","z-index":"","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"5225","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>*Terms applied</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"11px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"sh1","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5249","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"0px","t-right":"3px","b-right":"3px","b-left":"0px","settings":"unlink"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5382","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"45px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Recommended","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Recommended","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/traveltour/main4/tour-grid-3-columns/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"8px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#e66836","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"400","text-letter-spacing":"0px","text-transform":"","icon-size":"17px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"52px"}},{"template":"element","type":"tour","value":{"id":"","class":"","category":"","tag":["our-recommended"],"tour-age":"","tour-activity":"","tour-destination":"","Price":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","grid-style":"style-2","column-size":"20","thumbnail-size":"Personnel Thumbnail","enable-thumbnail-zoom-on-hover":"enable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation-outer","display-price":"enable","price-position":"right-title","price-prefix-text":"","tour-info":["duration-text"],"excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"18px","tour-title-font-weight":"800","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","frame-shadow-size":{"x":"","y":"","size":"23px","settings":"unlink"},"frame-shadow-color":"#0a0a0a","frame-shadow-opacity":"0.08","tour-border-radius":"3px","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5252","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"bottom-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"190px","right":"0px","bottom":"160px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Traveling Highlights","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"55px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Your New Traveling Idea","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ff7d5d","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"34px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"5253","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=HODmbzOT288&list=PLNIFTA4Bjp3stwYxIB6Aokpr9bfRQYO73","page-id":"5225","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5385","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Customer Reviews","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"60px"}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Luaka Smith","position":"Solo Traveler","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna.","image":"5259","image-img":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2019/04/photo-1428931996691-a5108d4cdbf5.jpg","rating":"10"},{"title":"Jane Doe","position":"Solo Traveler","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna.","image":"5260","image-img":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2019/04/shutterstock_666258808.jpg","rating":"10"},{"title":"John Smith","position":"Solo Traveler","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna.","image":"5261","image-img":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2019/04/pstraveltour2.jpg","rating":"9"},{"title":"Jane Smith","position":"Blogger","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna.","image":"4905","image-img":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2017/01/TNK87N7464.jpg","rating":"9"},{"title":"Paula Tana","position":"Traveler","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna.","image":"4904","image-img":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2017/01/photo-1428931996691-a5108d4cdbf5.jpg","rating":"10"}],"style":"left","with-frame":"enable","column":"3","thumbnail-size":"thumbnail","enable-quote":"enable","left-quote-position":"top","quote-position":"bottom","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-nav-style":"gdlr-core-plain-style","carousel-bullet-style":"default","title-size":"28px","title-text-transform":"none","title-font-weight":"","title-letter-spacing":"","content-size":"15px","name-size":"","name-font-weight":"","name-letter-spacing":"","name-text-transform":"","caption-size":"16px","position-font-style":"","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f5f5f5","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":"","container-margin":"","container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":"","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":"","mobile-margin":"","skin":""},"items":[{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Browse Tour By Category","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-sliders","left-image":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"24px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"32px"}}]},{"template":"wrapper","type":"column","column":"24","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Newsletter","caption":"","caption-position":"top","title-link-text":"View All Tours","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-envelope-o","left-image":"","heading-tag":"h3","icon-font-size":"22px","title-font-size":"24px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#467fe7","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"23px"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"","icon-hover":"","title":"Outdoor Activites","caption":"","link-url":"http://demo.goodlayers.com/traveltour/tour-activity/city-tours/","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"City Tours","caption":"","link-url":"http://demo.goodlayers.com/traveltour/tour-activity/city-tours/","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Cultural & Thematic Tours","caption":"","link-url":"http://demo.goodlayers.com/traveltour/tour-activity/cultural-thematic-tours/","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Indulgence & Luxury Tours","caption":"","link-url":"http://demo.goodlayers.com/traveltour/tour-activity/indulgence-luxury-tours/","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Family Friendly Tours","caption":"","link-url":"http://demo.goodlayers.com/traveltour/tour-activity/family-friendly-tours/","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Relaxation Tours","caption":"","link-url":"http://demo.goodlayers.com/traveltour/tour-activity/relaxation-tours/","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Holiday & Seasonal Tours","caption":"","link-url":"http://demo.goodlayers.com/traveltour/tour-activity/holiday-seasonal-tours/","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Wild & Adventure Tours","caption":"","link-url":"http://demo.goodlayers.com/traveltour/tour-activity/wild-adventure-tours/","link-target":"_self"}],"columns":"30","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#f97150","caption-color":"","border-color":"","icon-size":"14px","content-size":"15px","content-font-weight":"400","content-text-transform":"","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"13px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":"","mobile-margin":"","skin":"White Newsletter"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Subscribe for updates & promotions","text-align":"left","font-size":"","padding-bottom":"0px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle","shadow-size":"","shadow-color":"","shadow-opacity":"0.2","padding-bottom":"25px"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"","lastfm":"","linkedin":"","pinterest":"#","rss":"","skype":"","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"#","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"19px","with-text":"disable","text-size":"15px","icon-color":"#aaaaaa","icon-space":"20px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5377","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent Articles","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read The Blog","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"8px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#e66836","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"400","text-letter-spacing":"0px","text-transform":"","icon-size":"17px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"40px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":["article"],"num-fetch":"3","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-image","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-1","blog-image-style":"style-3","blog-widget-style":"style-1","blog-full-alignment":"left","blog-image-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"enable","blog-image-thumbnail-overlay":"opacity","blog-image-thumbnail-overlay-opacity":"0.4","blog-image-thumbnail-overlay-color":"#000000","show-thumbnail":"enable","thumbnail-size":"Tour Side Thumbnail","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-bullet-style":"default","blog-widget-column":"60","blog-widget-bottom-divider":"disable","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","author"],"show-read-more":"enable","filterer-bottom-margin":"","blog-title-font-size":"","blog-title-font-weight":"","blog-title-letter-spacing":"","blog-title-text-transform":"none","category-background-color":"#f97150","frame-shadow-size":"","frame-shadow-color":"#f97150","frame-shadow-opacity":"0.2","blog-border-radius":"","blog-frame-padding":"","blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"45px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are featured in","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>See what others are saying about us</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"30px"}},{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"5386","thumbnail":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2019/04/banner-1-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5387","thumbnail":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2019/04/banner-2-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5388","thumbnail":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2019/04/banner-3-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5389","thumbnail":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2019/04/banner-4-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5390","thumbnail":"https://demo.goodlayers.com/traveltour/main3/wp-content/uploads/2019/04/banner-5-150x129.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","image-bottom-margin":"","padding-bottom":"0px"}}]}]';
				case 'home-hiking':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Search HP"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Search For Tour","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#193555","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"10px"}},{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"Search For Tour","fields":["tour-activity","tour-destination","duration","date"],"style":"column","input-size":"small","item-style":"style-1","input-box-style":"transparent-bottom-border","enable-rating-field":"disable","filter-state":"disable","filters":"","with-frame":"disable","frame-background-color":"#193555","frame-background-image":"","space-between-input":"","padding-bottom":"10px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5456","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5398","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5395","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Why choose us?","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"38px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#193555","title-link-hover-color":"","caption-color":"","caption-spaces":"","media-margin-right":"15px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"46px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ffa019"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>It\'s our passion and our expertise, and has been for over two decades. We know the trails and the towns inside and out. We know the hoteliers and their rooms, and restauranteurs and their menus. We don\'t guide on any route we haven\'t done many times before. Our expertise gives you a richer, more enjoyable experience, and we will makes better use of your time. </p><p> </p><p>We provide a thorough and complete orientation, so you are fully prepared to make the most of your Swiss vacation or Alps hiking adventure. Your expert trip leader is with you for the entire trip.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#687d8e","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","full-width-button":"disable","button-padding":{"top":"","right":"","bottom":"","left":"0px","settings":"unlink"},"border-radius":"","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#193555","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"600","text-letter-spacing":"","text-transform":"","icon-size":"","button2-left-margin":"","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height1","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"right","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5459","background-image-style":"no-repeat","background-image-position":"center-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"640px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"40px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5554","mobile-background-image":"","background-image-style":"repeat-x","background-image-position":"bottom-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"COLUM SVC  20 YEARS"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"","right":"5px","bottom":"","left":"5px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5424","character":"","title":"20 Years Experiences","caption":"","caption-position":"top","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"2px","title-text-transform":"uppercase","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"35px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"23px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"5px","bottom":"0px","left":"5px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5425","character":"","title":"Lots of gears","caption":"","caption-position":"top","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"2px","title-text-transform":"uppercase","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"35px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"23px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"5px","bottom":"0px","left":"5px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5426","character":"","title":"Most completed map","caption":"","caption-position":"top","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"2px","title-text-transform":"uppercase","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"35px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"23px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"","right":"5px","bottom":"","left":"5px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5427","character":"","title":"Packing Advise","caption":"","caption-position":"top","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"2px","title-text-transform":"uppercase","caption-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"35px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"23px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5437","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height2","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5518","background-image-style":"no-repeat","background-image-position":"center-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height2","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"0px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5455","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5395","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"ABout Alps","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"38px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#193555","title-link-hover-color":"","caption-color":"","caption-spaces":"","media-margin-right":"15px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"45px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ffa019"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The Alps are the highest and most extensive mountain range system that lies entirely in Europe, separating Southern from Central and Western Europe and stretching approximately 1,200 kilometres across eight Alpine countries: France, Switzerland, Italy, Monaco, Liechtenstein, Austria, Germany, and Slovenia.</p><p> </p><p>To make the most of your vacation experience, you’ll want to plan your itinerary and activities to take advantage of the best weather and optimal conditions. Remember, the Alps is located at a latitude between 46° and 47° north.</p><p> </p><p> </p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#687d8e","padding-bottom":"20px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5562","mobile-background-image":"","background-image-style":"repeat-x","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"200px","right":"0px","bottom":"175px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","category":"","tag":"","tour-age":"","tour-activity":"","tour-destination":"","num-fetch":"8","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"enable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","grid-style":"style-2","column-size":"20","thumbnail-size":"Personnel Thumbnail","enable-thumbnail-zoom-on-hover":"disable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","display-price":"enable","price-position":"right-title","price-prefix-text":"","tour-info":["duration-text"],"excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"18px","tour-title-font-weight":"700","tour-title-letter-spacing":"1px","tour-title-text-transform":"uppercase","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","tour-border-radius":"","padding-bottom":"60px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"Find our popular tours","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"28px","title-letter-spacing":"2px","title-line-height":"","title-font-style":"normal","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"gdlr-core-plain-style-2"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/traveltour/hiking/tour-grid-3-columns/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"37px","bottom":"21px","left":"37px","settings":"unlink"},"border-radius":"30px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#193555","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"700","text-letter-spacing":"","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"COUNTER SKIN "},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5478","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"35px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"0","end-number":"2000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Awesome hikers","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"50px","number-font-weight":"700","bottom-text-size":"18px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5478","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"35px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"0","end-number":"30","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Stunning places","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"50","number-font-weight":"700","bottom-text-size":"18px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5478","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"35px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Miles to hike","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"50","number-font-weight":"700","bottom-text-size":"18px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5478","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"35px","right":"30px","bottom":"55px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"0","end-number":"2500","animation-time":"","suffix":"","divider":"disable","bottom-text":"Days in service","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"50","number-font-weight":"700","bottom-text-size":"18px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. </p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"15px","content-font-weight":"400","content-letter-spacing":"1px","content-text-transform":"uppercase","text-color":"#a7b2bf","padding-bottom":"20px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5588","mobile-background-image":"","background-image-style":"repeat-x","background-image-position":"bottom-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"150px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Customer Review","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"3px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#193555","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"45px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"60px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ffa019"}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Luaka Smith","position":"Solo Traveler","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna, vel scelerisq.","image":"5620","image-img":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/photo-1428931996691-a5108d4cdbf5-683x1024.jpg","rating":"10"},{"title":"Jane Smith","position":"Journalist","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna, vel scelerisq.","image":"5619","image-img":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/TNK87N7464.jpg","rating":"9"},{"title":"John Smith","position":"Blogger","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna, vel scelerisq.","image":"5621","image-img":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/pstraveltour2-768x597.jpg","rating":"10"},{"title":"Jane Doe","position":"Solo Traveler","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna, vel scelerisq.","image":"5622","image-img":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/shutterstock_666258808-768x512.jpg","rating":"9"},{"title":"Matt Doe","position":"Couple","content":"Donec ullamcorper nulla non metus auctor fringilla. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit. Praesent commodo cursus magna, vel scelerisq.","image":"5571","image-img":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/04/product-2.jpg","rating":"10"}],"style":"left","with-frame":"enable","column":"3","thumbnail-size":"thumbnail","enable-quote":"enable","left-quote-position":"top","quote-position":"bottom","carousel":"enable","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-nav-style":"default","carousel-bullet-style":"default","title-size":"15px","title-text-transform":"none","title-font-weight":"400","title-letter-spacing":"","content-size":"15px","name-size":"17px","name-font-weight":"","name-letter-spacing":"","name-text-transform":"none","caption-size":"16px","position-font-style":"","title-color":"#6a7581","caption-color":"#6a7581","quote-color":"#193555","content-color":"#6a7581","name-color":"#6a7581","position-color":"#6a7581","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Shop Hiking Gear","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"3px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#193555","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"45px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"50px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ffa019"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Visit Shop","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/traveltour/hiking/shop","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#193555","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"600","text-letter-spacing":"","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"element","type":"product","value":{"id":"","class":"","category":"","tag":"","num-fetch":"8","stock-status":"all","orderby":"date","order":"desc","product-style":"grid","thumbnail-size":"Personnel Square","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"carousel","carousel-autoslide":"disable","carousel-scrolling-item-amount":"2","carousel-navigation":"bullet","carousel-bullet-style":"default","pagination":"none","pagination-style":"default","pagination-align":"default","product-title-font-size":"18px","product-title-font-weight":"700","product-title-letter-spacing":"1px","product-title-text-transform":"uppercase","padding-bottom":"30px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffa11a","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-newsletter","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5498","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"375px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-newsletter","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"","bottom":"80px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Newsletter form"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Subscribe","caption":"To receive promotions and newsletter","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"3px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"transparent-bottom-border","shadow-size":"","shadow-color":"","shadow-opacity":"0.2","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are featured in","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"3px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#193555","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"15px","padding-bottom":"23px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"45px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"55px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ffa019"}},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5501","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5395","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5502","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5395","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5503","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5395","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5499","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5395","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5500","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5395","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"5611","thumbnail":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/red-hat-factory-768348-unsplash-150x150.jpg"},{"id":"5612","thumbnail":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/ryan-stone-1266847-unsplash-150x150.jpg"},{"id":"5613","thumbnail":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/tyler-nix-567726-unsplash-150x150.jpg"},{"id":"5610","thumbnail":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/pablo-acevedo-111046-unsplash-150x150.jpg"},{"id":"5609","thumbnail":"https://demo.goodlayers.com/traveltour/hiking/wp-content/uploads/2019/05/jasper-guy-201670-unsplash-150x150.jpg"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid-no-space","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"masonry","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"Personnel Thumbnail 2","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","image-bottom-margin":"","padding-bottom":"0px"}}]}]';
				case 'home-golf':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#183036","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"4","z-index":"","padding-bottom":"0px"}},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"curve","custom-shape":"","custom-image":"","inverted":"disable","flip":"disable","vflip":"disable","opacity":"","color":"#ffffff","width":"110%","height":"110px","hide-this-item-in":"mobile","z-index":"9"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"10","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"enable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"container-margin":{"top":"-220px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"container-border-radius":{"t-left":"","t-right":"","b-right":"","b-left":"","settings":"link"},"container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"hp-column-service","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"#262a4c","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5950","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5946","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"50px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Tournaments","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"0px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We will take care of each detail offering a unique and exclusive experience</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"14px","right":"38px","bottom":"16px","left":"38px","settings":"unlink"},"border-radius":"5px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#aa9875","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"35px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"hp-column-service","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"#262a4c","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5965","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5946","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"57px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Personal Interaction","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"0px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We will take care of each detail offering a unique and exclusive experience</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"14px","right":"38px","bottom":"16px","left":"38px","settings":"unlink"},"border-radius":"5px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#aa9875","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"35px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"hp-column-service","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"#262a4c","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5966","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5946","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"60px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Golf Tour","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin-right":"0px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We will take care of each detail offering a unique and exclusive experience</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"14px","right":"38px","bottom":"16px","left":"38px","settings":"unlink"},"border-radius":"5px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#aa9875","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"35px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"105px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Professional Golf Tour Experience","caption":"Professional and Amateaur Golf Experience","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"#aa9875","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"600px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Travel Golf Tour’s aim is to make each participant live in first person the experience of playing in a professional golf circuit.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5969","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"435px","right":"","bottom":"300px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"H Golf","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"10px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Access to some of the greatest golf courses and exclusive clubs","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"#aa9875","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our team will organise your trip and be on hand to provide a unique golfing experience, providing you the opportunity to play some of the top links courses in the world under the guidance of a PGA Tour Professional. Check our tour program:</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"45px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"fa fa-check-circle","icon-hover":"","title":"10 Tournaments and a grand final","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-check-circle","icon-hover":"","title":"18 holes stableford format","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-check-circle","icon-hover":"","title":"General Travel Tour ranking","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-check-circle","icon-hover":"","title":"Play a practice round","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"#aa9875","icon-background-color":"","content-color":"#556575","caption-color":"","border-color":"","icon-size":"18px","content-size":"16px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"16px","caption-font-weight":"500","caption-text-transform":"none","caption-letter-spacing":"0px","image-max-width":"","icon-top-margin":"4px","icon-right-margin":"15px","list-bottom-margin":"10px","padding-bottom":"45px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Discover Now","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/golf/tour-grid-3-columns/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"16px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#aa9875","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5977","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"110px","right":"","bottom":"110px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"850px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Whether you\'re a small group or a corporate group, we will have the perfect package for you.","caption":"All Inclusive Golf Tour Packages","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#f2f2f2","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"50px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/golf/tour-grid-3-columns/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#aa9875","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5949","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Browse the largest selection of golf packages","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"600px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Travel Golf Tour’s aim is to make each participant live in first person the experience of playing in a professional golf circuit.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","relation":"or","category":"","tag":"","tour-activity":"","tour-destination":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","grid-style":"style-3","column-size":"20","thumbnail-size":"Personnel Thumbnail","enable-thumbnail-zoom-on-hover":"disable","layout":"carousel","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":"fa fa-angle-left","carousel-navigation-right-icon":"fa fa-angle-right","carousel-navigation-icon-color":"#7c7c7c","carousel-navigation-icon-bg":"#f3f3f3","carousel-navigation-icon-padding":{"top":"17px","right":"20px","bottom":"17px","left":"20px","settings":"unlink"},"carousel-navigation-icon-radius":"6px","carousel-navigation-size":"19px","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"-90px","carousel-bullet-style":"default","carousel-bullet-top-margin":"","display-price":"enable","price-position":"right-title","price-prefix-text":"","tour-info":["duration-text","availability"],"excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"24px","tour-title-font-weight":"400","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","frame-padding":"","frame-border-size":"","frame-border-color":"","frame-hover-border-color":"","frame-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-shadow-color":"#000000","frame-shadow-opacity":"0.08","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","tour-border-radius":"10px","padding-bottom":"50px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"24px","title-font-weight":"400","title-letter-spacing":"","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#222222","caption-color":"#556575","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Popular Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/golf/search-tours/","button-link-target":"_self","icon-position":"right","icon":"fa fa-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#777777","icon-color":"#777777","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"16px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5988","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"80px","right":"80px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We will help you to create an truly unforgettable experience","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our travel team are on hand to organise hotels and private houses, all transport requirements and even meals in some of the finest restaurants in Europe.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"60px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Tour Search","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/golf/search-tours/?tour-search=&tax-tour-destination=&duration=","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"13px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#aa9875","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"","text-transform":"","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5986","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=byEuCnGm8oA","page-id":"5946","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom-image","overlay-icon-style":"always-show-2","overlay-icon":"fa fa-android","overlay-image":"5987","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"10px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"","overlay-icon-size":"custom","overlay-icon-size-custom":"100px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We provide the best golf tours service","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Search for tour. Travel Tour Golf vacation packages offers a selection of the best golf courses, carefully selected hotels and VIP transportation.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"820px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"","fields":["tour-activity","tour-destination","month"],"style":"column","input-size":"medium","item-style":"style-1","input-box-style":"round-border","enable-rating-field":"disable","filter-state":"disable","filters":"","with-frame":"enable","frame-background-color":"","frame-background-image":"","space-between-input":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f8faff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6013","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"98px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"48","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"17px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Visit our trending tours","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"5px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/golf/search-tours/?tour-search=&tax-tour-destination=&duration=","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"right","full-width-button":"disable","button-padding":{"top":"12px","right":"50px","bottom":"12px","left":"50px","settings":"unlink"},"border-radius":"5px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#aa9875","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"","text-transform":"","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"-300px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","relation":"or","category":"","tag":["our-recommended","top-destination"],"tour-activity":"","tour-destination":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","grid-style":"style-3","column-size":"20","thumbnail-size":"Personnel Thumbnail","enable-thumbnail-zoom-on-hover":"disable","layout":"carousel","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":"fa fa-angle-left","carousel-navigation-right-icon":"fa fa-angle-right","carousel-navigation-icon-color":"#7c7c7c","carousel-navigation-icon-bg":"#f3f3f3","carousel-navigation-icon-padding":{"top":"17px","right":"20px","bottom":"17px","left":"20px","settings":"unlink"},"carousel-navigation-icon-radius":"6px","carousel-navigation-size":"19px","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"-90px","carousel-bullet-style":"default","carousel-bullet-top-margin":"","display-price":"enable","price-position":"right-title","price-prefix-text":"","tour-info":["duration-text","availability"],"excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"24px","tour-title-font-weight":"400","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","frame-padding":"","frame-border-size":"","frame-border-color":"","frame-hover-border-color":"","frame-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-shadow-color":"#000000","frame-shadow-opacity":"0.08","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","tour-border-radius":"10px","padding-bottom":"50px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"24px","title-font-weight":"400","title-letter-spacing":"","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#222222","caption-color":"#556575","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"310px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"260px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#1d2b36","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5972","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.5","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"110px","right":"","bottom":"110px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"840px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Join our subscribers list to get the latest news, updates and special offers directly in your inbox!","caption":"Subscribe to our newsletter today!","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#f2f2f2","caption-spaces":"15px","media-margin-right":"15px","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"520px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"round","shadow-size":"","shadow-color":"","shadow-opacity":"0.2","padding-bottom":"10px"}}]}]}]';
				case 'home-museum':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#283035","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"4","z-index":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"-0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"-324px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","relation":"or","category":"","tag":"","tour-activity":"","tour-destination":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","grid-style":"style-4","column-size":"20","thumbnail-size":"Personnel Thumbnail","enable-thumbnail-zoom-on-hover":"disable","layout":"carousel","carousel-scrolling-item-amount":"2","carousel-autoslide":"enable","carousel-navigation":"bullet","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"cylinder gdlr-core-style-2","carousel-bullet-top-margin":"70px","display-price":"enable","price-position":"right-title","price-prefix-text":"","tour-info":"","excerpt":"specify-number","excerpt-number":"11","tour-rating":"enable","tour-title-font-size":"24px","tour-title-font-weight":"500","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","frame-padding":{"top":"","right":"35px","bottom":"","left":"35px","settings":"unlink"},"frame-border-size":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-shadow-size":{"x":"0px","y":"20px","size":"35px","settings":"unlink"},"frame-shadow-color":"#0a0a0a","frame-shadow-opacity":"0.09","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","tour-border-radius":"10px","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We create tours for groups around the world","caption":" Museums, Art, Tours, Attractions and Much More","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"#7d7d7d","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"80px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We help you get the best from museums, tours, activities and destinations by providing a great choice of local tours and attractions.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"10px","bottom":"35px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5660","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5656","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"60px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Ticket Tours","caption":"We will take care of each detail offering a unique and exclusive experience","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"#556575","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#aa9875","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5663","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"10px","bottom":"35px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5667","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5656","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"50px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":" Museums & Art ","caption":"We will take care of each detail offering a unique and exclusive experience","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"solid","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#aa9875","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"10px","bottom":"35px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5662","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"5656","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"60px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Attractions","caption":"We will take care of each detail offering a unique and exclusive experience","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"#556575","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#aa9875","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5673","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"130px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Find your dream tour today! Take a look at our most popular museums.","caption":"Know More About Our Guided Tours","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#aa9875","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"35px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"solid","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#aa9875","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"48","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Choose your destination","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/museum/search-tours/?tour-search=&tax-tour-destination=&duration=","button-link-target":"_self","icon-position":"right","icon":"fa fa-arrow-right","z-index":"","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"5px","button-background":"transparent","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#aa9875","icon-color":"#aa9875","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"tour_category","value":{"id":"","class":"","filter-type":"tour-destination","category":"","tour_tag":"","tour-activity":"","tour-destination":["london","paris","rome"],"num-fetch":"3","orderby":"name","order":"desc","style":"grid-4","column-size":"20","thumbnail-size":"Large Landscape 3","excerpt":"specify-number","excerpt-number":"55","with-feature":"enable","feature-thumbnail-size":"full","feature-excerpt":"specify-number","feature-excerpt-number":"55","border-radius":"","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5692","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"5829","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"105px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"800px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"60px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Book tickets to museums and tours","caption":"Find and book tickets, sightseeing tours, attractions and things to do from around the world with Travel Tour. Flexible planning with fast and hassle-free tickets/vouchers.","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"#556575","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5674","character":"","title":"Secure Booking","caption":"","caption-position":"bottom","content":"<p>We help travellers get the best from tours and destinations.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"18px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"11px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"10px","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5693","character":"","title":"Cultural Tours","caption":"","caption-position":"bottom","content":"<p>We help travellers get the best from tours and destinations.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"18px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"11px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"10px","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5694","character":"","title":" Transportation","caption":"","caption-position":"bottom","content":"<p>We help travellers get the best from tours and destinations.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"18px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"11px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"10px","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5695","character":"","title":"A Great Choice","caption":"","caption-position":"bottom","content":"<p>We help travellers get the best from tours and destinations.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"18px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"11px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":""},"media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"10px","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Date & Pricing","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"13px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#aa9875","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"-238px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"75px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"48","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Popular tour packages","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/museum/search-tours/?tour-search=&tax-tour-destination=&duration=","button-link-target":"_self","icon-position":"right","icon":"fa fa-arrow-right","z-index":"","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"5px","button-background":"transparent","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#aa9875","icon-color":"#aa9875","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#aa9875","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"0px","text-transform":"none","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"99","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","relation":"or","category":"","tag":["popular-deals"],"tour-activity":"","tour-destination":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","grid-style":"style-4","column-size":"30","thumbnail-size":"Blog Column Thumbnail","enable-thumbnail-zoom-on-hover":"disable","layout":"carousel","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":"fa fa-angle-left","carousel-navigation-right-icon":"fa fa-angle-right","carousel-navigation-icon-color":"#7c7c7c7","carousel-navigation-icon-bg":"#f3f3f3","carousel-navigation-icon-padding":{"top":"17px","right":"20px","bottom":"17px","left":"20px","settings":"unlink"},"carousel-navigation-icon-radius":"6px","carousel-navigation-size":"19px","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"-90px","carousel-bullet-style":"cylinder gdlr-core-style-2","carousel-bullet-top-margin":"70px","display-price":"enable","price-position":"right-title","price-prefix-text":"","tour-info":"","excerpt":"specify-number","excerpt-number":"","tour-rating":"enable","tour-title-font-size":"24px","tour-title-font-weight":"500","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","frame-padding":"","frame-border-size":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-shadow-size":{"x":"0px","y":"20px","size":"35px","settings":"unlink"},"frame-shadow-color":"#0a0a0a","frame-shadow-opacity":"0.09","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","tour-border-radius":"10px","padding-bottom":"30px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f8faff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"340px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"10px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We provide the best museum tours service","caption":"We help travellers get the best from destinations by providing a great choice of local tours and attractions bookable on multiple devices.","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"#556575","caption-spaces":"20px","media-margin-right":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"1000px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour_search","value":{"id":"","class":"","title":"","fields":["keywords","tour-activity","tour-destination"],"style":"column","input-size":"medium","item-style":"style-1","input-box-style":"round-border","enable-rating-field":"disable","filter-state":"disable","filters":"","with-frame":"enable","frame-background-color":"#f8faff","frame-background-image":"","space-between-input":"","padding-bottom":"30px"}}]}]}]';
				case 'home-winery':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#1d2b36","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"4","z-index":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"main","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column SVC Top"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"950px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Exclusive Napa Valley Wineries Tour","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"6px","divider-width":"70px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#982d30"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Comfortable transportation collects you from your hotel and carries your group to four distinct wineries, where you can enjoy tastings at your own expense.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5485","character":"","title":"Premium Wines","caption":"","caption-position":"bottom","content":"<p>Discover the Napa Valley at a relaxed pace on a 5-hour small-group tour.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"default","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5486","character":"","title":"Guided Tours","caption":"","caption-position":"bottom","content":"<p>Discover the Napa Valley at a relaxed pace on a 5-hour small-group tour.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"default","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5487","character":"","title":"Winery Tour","caption":"","caption-position":"bottom","content":"<p>Discover the Napa Valley at a relaxed pace on a 5-hour small-group tour.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"default","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5488","character":"","title":"Picnic Lunch","caption":"","caption-position":"bottom","content":"<p>Discover the Napa Valley at a relaxed pace on a 5-hour small-group tour.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"default","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5489","character":"","title":"Wine Tasting","caption":"","caption-position":"bottom","content":"<p>Discover the Napa Valley at a relaxed pace on a 5-hour small-group tour.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"default","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"10px","t-right":"10px","b-right":"10px","b-left":"10px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"0px","y":"20px","size":"70px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.1","padding":{"top":"35px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5490","character":"","title":"Grape Varieties","caption":"","caption-position":"bottom","content":"<p>Discover the Napa Valley at a relaxed pace on a 5-hour small-group tour.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"default","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"16px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"60px","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"55px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Destinations","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/winery/search-tours/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#982d30","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#982d30","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"500","text-letter-spacing":"","text-transform":"","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5492","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Winery HP2","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5491","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"","right":"10px","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Winery HP2","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"90px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Visit up to five renowned wineries selected in Napa by a guide","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>There is no better way to learn about the Napa Valley and all it has to offer than on a guided tour. There is something for everyone – whether you are looking to drink, eat, get fit, learn, or all of the above!</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"fa fa-check-circle","icon-hover":"","title":"5-hour Napa Valley wine tour","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-check-circle","icon-hover":"","title":"Learn about local winemaking","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-check-circle","icon-hover":"","title":"Transport by small shuttle","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-check-circle","icon-hover":"","title":"Hotel pickup and drop-off","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"#982d30","icon-background-color":"","content-color":"#556575","caption-color":"#556575","border-color":"","icon-size":"19px","content-size":"16px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"","caption-size":"15px","caption-font-weight":"","caption-text-transform":"none","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"6px","icon-right-margin":"16px","list-bottom-margin":"10px","padding-bottom":"50px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Tour List","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/winery/search-tours/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"46px","bottom":"15px","left":"46px","settings":"unlink"},"border-radius":"5px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#982d30","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"tour","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"75px","right":"","bottom":"65px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column SVC Top"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"950px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Browse the largest selection of winery tours","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"7px","divider-width":"70px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#982d30"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>California is known for our wineries, but when looking for a great place to stay to experience all that a wine country town can offer, we know you have lots of options!</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#556575","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tour","value":{"id":"","class":"","relation":"or","category":"","tag":"","tour-activity":"","tour-destination":"","num-fetch":"9","orderby":"date","order":"desc","discount-status":"all","hide-not-avail":"disable","enable-order-filterer":"disable","order-filterer-list-style":"none","order-filterer-list-style-thumbnail":"full","order-filterer-grid-style":"none","order-filterer-grid-style-thumbnail":"full","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","tour-style":"grid-with-frame","grid-style":"style-3","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"disable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":"fa fa-angle-left","carousel-navigation-right-icon":"fa fa-angle-right","carousel-navigation-icon-color":"#7c7c7c","carousel-navigation-icon-bg":"#f3f3f3","carousel-navigation-icon-padding":{"top":"17px","right":"20px","bottom":"17px","left":"20px","settings":"unlink"},"carousel-navigation-icon-radius":"6px","carousel-navigation-size":"19px","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"-90px","carousel-bullet-style":"default","carousel-bullet-top-margin":"","display-price":"enable","price-position":"right-title","price-prefix-text":"","tour-info":["duration-text","availability"],"excerpt":"none","excerpt-number":"55","tour-rating":"enable","tour-title-font-size":"24px","tour-title-font-weight":"400","tour-title-letter-spacing":"0px","tour-title-text-transform":"none","frame-padding":"","frame-border-size":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"frame-border-color":"#ebebeb","frame-hover-border-color":"#ffffff","frame-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"frame-shadow-color":"","frame-shadow-opacity":"","enable-move-up-shadow-effect":"enable","move-up-effect-length":"20px","frame-hover-shadow-size":{"x":"0px","y":"25px","size":"45px","settings":"unlink"},"frame-hover-shadow-color":"#0a0a0a","frame-hover-shadow-opacity":"0.09","tour-border-radius":"10px","padding-bottom":"50px","tour-title-bottom-margin":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"24px","title-font-weight":"400","title-letter-spacing":"","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#222222","caption-color":"#556575","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Popular Tours","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/traveltour/homepages/winery/search-tours/?tour-search=&tax-tour_tag%5B%5D=popular-deals&duration=&date=&month=&min-price=&max-price=&rating=0","button-link-target":"_self","icon-position":"right","icon":"fa fa-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"5px","button-background":"transparent","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#777777","icon-color":"#777777","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#982d30","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"500","text-letter-spacing":"","text-transform":"","icon-size":"14px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5493","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Winery Height00","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"90px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Take a tour from the experts who know Napa Valley & California","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"39px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5496","character":"","title":"Wine Tasting","caption":"","caption-position":"bottom","content":"<p>Whether it\'s for a week, a day, a glass or a meal – now\'s the perfect time to experience the Napa Valley Spirit for yourself.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left-title","heading-tag":"h3","icon-size":"30px","title-size":"17px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"4px","right":"15px","bottom":"","left":""},"media-image-max-width":"30px","character-width":"","title-top-padding":"4px","title-bottom-margin":"15px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5497","character":"","title":"Grape Varieties","caption":"","caption-position":"bottom","content":"<p>Whether it\'s for a week, a day, a glass or a meal – now\'s the perfect time to experience the Napa Valley Spirit for yourself.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left-title","heading-tag":"h3","icon-size":"30px","title-size":"17px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"13px","bottom":"","left":""},"media-image-max-width":"30px","character-width":"","title-top-padding":"4px","title-bottom-margin":"15px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5498","character":"","title":"Private Dining","caption":"","caption-position":"bottom","content":"<p>Whether it\'s for a week, a day, a glass or a meal – now\'s the perfect time to experience the Napa Valley Spirit for yourself.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left-title","heading-tag":"h3","icon-size":"30px","title-size":"17px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"3px","right":"13px","bottom":"","left":""},"media-image-max-width":"30px","character-width":"","title-top-padding":"4px","title-bottom-margin":"15px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"Winery Height00","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Winery Height00","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"right","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5494","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"","right":"0px","bottom":"","left":"40px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"5506","thumbnail":"https://demo.goodlayers.com/traveltour/homepages/winery/wp-content/uploads/sites/2/2021/06/GLY01-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5507","thumbnail":"https://demo.goodlayers.com/traveltour/homepages/winery/wp-content/uploads/sites/2/2021/06/GLY02-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5508","thumbnail":"https://demo.goodlayers.com/traveltour/homepages/winery/wp-content/uploads/sites/2/2021/06/GLY03-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5509","thumbnail":"https://demo.goodlayers.com/traveltour/homepages/winery/wp-content/uploads/sites/2/2021/06/GLY04-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","icon-hover-style":"icon_zoom-in_alt","show-caption":"disable","overlay-on-hover":"disable","column":"4","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","border-radius":"","image-left-right-margin":"","image-bottom-margin":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5517","background-image-top-offset":"","background-image-bottom-offset":"300px","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"75px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"48","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Wine delivered right to your door","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"5px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View Our Shop","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-arrow-right","z-index":"","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#982d30","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"14px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"product","value":{"id":"","class":"","category":"","tag":"","relation":"or","num-fetch":"9","stock-status":"all","orderby":"date","order":"desc","product-style":"grid-5","excerpt-number":"11","price-location":"after-title","display-attribute-amount":"","button-style":"plain","button-border-color":"","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"2","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"cylinder gdlr-core-style-2","pagination":"none","pagination-style":"default","pagination-align":"default","product-title-font-size":"24px","product-title-font-weight":"500","product-title-letter-spacing":"","product-title-text-transform":"none","border-radius":"10px","frame-padding":"","frame-border-size":"10px","frame-border-color":"","frame-shadow-size":{"x":"0px","y":"20px","size":"35px","settings":"unlink"},"frame-shadow-color":"#262a4c","frame-shadow-opacity":"0.09","enable-move-up-shadow-effect":"enable","move-up-effect-length":"20px","frame-hover-shadow-size":{"x":"0px","y":"20px","size":"35px","settings":"unlink"},"frame-hover-shadow-color":"#262a4c","frame-hover-shadow-opacity":"0.09","carousel-bullet-top-margin":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5516","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"repeat-x","background-image-position":"bottom-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"75px","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Join our subscribers list and save $20 off your first order of $100.","caption":"Subscribe to our newsletter today!","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","caption-color":"#556575","caption-spaces":"10px","media-margin-right":"15px","padding-bottom":"50px"}},{"template":"element","type":"newsletter"}]}]}]';
				case 'about-us':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"109px","right":"80px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Amet Etiam Quam","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Vestibulum id ligula porta felis euismod semper. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Maecenas sed diam eget risus varius blandit sit amet non magna. Maecenas sed diam eget risus varius blandit sit amet non magna.</p>","text-align":"left","font-size":"17px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Branding","icon":"","percent":"90","bar-text":""},{"heading-text":"Graphic Design","icon":"","percent":"100","bar-text":""},{"heading-text":"Social Marketing","icon":"","percent":"85","bar-text":""},{"heading-text":"Product Design","icon":"","percent":"90","bar-text":""}],"heading-text-color":"","icon-color":"","percent-color":"","bar-filled-color":"#161616","bar-background-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"#f1f0f0","background-image":"4491","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"right","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"110px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Pharetra Etiam Inceptos","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"33px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia.</p>","text-align":"left","font-size":"17px","padding-bottom":"15px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Vestibulum id ligula","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Mattis Fringilla Ultricies","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Egestas Fermentum","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Adipiscing Vulputate","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Ultricies Bibendum","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Fringilla Quam Elit","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Fermentum Tellus","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Commodo Vestibulum","link-url":"","link-target":"_self"}],"columns":"30","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"16px","content-size":"16px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"left","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"135px","right":"80px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About Services","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.</p><p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque ornare sem lacinia quam</p>","text-align":"left","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get A Quote","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"28px","bottom":"15px","left":"28px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"#111111","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"12px","icon-size":"","button2-left-margin":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"color","background-extending":"right","background-color":"#1f1f1f","background-image":"2181","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"50px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4569","title":"Ornare Quam Justo Tellusv","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"15px","right":"55px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4570","title":"Pellentesque Magna Venenatis","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"15px","right":"55px","bottom":"","left":"5px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4571","title":"Magna Nibh Commodo","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"15px","right":"43px","bottom":"0px","left":"13px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet The Team","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"60px"}},{"template":"element","type":"personnel","value":{"id":"","class":"","category":null,"num-fetch":"6","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid-with-background","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"Personnel Thumbnail 2","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"enable","carousel-navigation":"navigation","personnel-title-font-size":"","personnel-title-font-weight":"","personnel-title-letter-spacing":"","personnel-title-text-transform":"uppercase","personnel-position-font-size":"","personnel-position-font-weight":"","personnel-position-font-style":"normal","personnel-position-letter-spacing":"","personnel-position-text-transform":"none","personnel-thumbnail-bottom-margin":"","personnel-title-bottom-margin":"","padding-bottom":"30px","title-align":"center","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]}]';
				case 'about-us2':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"10px","bottom":"60px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Business Plan","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there.</p>","text-align":"center","font-size":"16px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"10px","bottom":"60px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Brand Identity","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there.</p>","text-align":"center","font-size":"16px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"10px","bottom":"60px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there.</p>","text-align":"center","font-size":"16px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"10px","bottom":"60px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Data Analyze","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there.</p>","text-align":"center","font-size":"16px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"#1f1f1f","background-image":"4527","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"70px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"none","icon":"fa fa-gear","icon-style":"normal","image":"","title":"Ornare Quam Justo Tellusv","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"40px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"none","icon":"fa fa-gear","icon-style":"normal","image":"2868","title":"Pellentesque Magna Venenatis","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"45px","bottom":"","left":"5px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"none","icon":"fa fa-gear","icon-style":"normal","image":"2869","title":"Magna Nibh Commodo","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"49px","bottom":"0px","left":"13px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"right","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"135px","right":"0px","bottom":"110px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Sollicitudin Vestibulum Vulputate Ipsum","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.</p><p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla.</p>","text-align":"left","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get A Quote","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"28px","bottom":"15px","left":"28px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"#232323","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"12px","icon-size":"","button2-left-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#3a3a3a","background-image":"4526","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"20000","animation-time":"4000","suffix":"+","divider":"disable","bottom-text":"Customers","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"1400","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"16800","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"17000","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"SKUs","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"109px","right":"20px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Etiam Vehicula Euismod  Fusce Fermentum .","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"33px","padding-bottom":"30px","icon-color":"","divider-color":"#353535"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Vestibulum id ligula porta felis euismod semper. Cras mattis consectetur purus sit amet fermentum. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.Ligula Dolor.</p>","text-align":"left","font-size":"17px","padding-bottom":"0px"}}]}]}]';
				case 'about-us3':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4529","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"350px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","title":"The Story","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"35px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"35px","caption-font-weight":"300","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"11px"}},{"template":"element","type":"title","value":{"id":"","title":"About Us","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"90px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"35px","caption-font-weight":"300","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f2f2f2","background-image":"1333","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are the best architect firm  <br/>& Building Consultant","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"50px","padding-bottom":"30px","icon-color":"","divider-color":"#565656"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Lorem ipsum dolor sit amet, consectetur adipiscing elit<br /><br /></p><p>Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam quis risus eget urna mollis ornare vel eu leo. Cras mattis consectetur purus sit amet fermentum. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit avmet risus.</p>","text-align":"left","font-size":"17px","padding-bottom":"20px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"1194","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.4","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4573","title":"We pride ourselves on innovative.","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"50px","left":""},"title-top-padding":"","title-bottom-margin":"27px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"text-box","value":{"id":"","content":"<a href=\"#\"><b>LEARN MORE</b> [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"15px\" color=\"#111\" margin-left=\"23px\" margin-right=\"\" ]</a>","text-align":"left","font-size":"13px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4574","title":"We won many awards.","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"27px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"text-box","value":{"id":"","content":"<a href=\"#\"><b>LEARN MORE</b> [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"15px\" color=\"#111\" margin-left=\"23px\" margin-right=\"\" ]</a>","text-align":"left","font-size":"13px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4581","title":"We are a team of genius people.","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"27px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"10px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"text-box","value":{"id":"","content":"<a href=\"#\"><b>LEARN MORE</b> [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"15px\" color=\"#111\" margin-left=\"23px\" margin-right=\"\" ]</a>","text-align":"left","font-size":"13px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4527","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"160px","right":"0px","bottom":"130px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","title":"Award Winnings","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"38px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"30px","icon-color":"","divider-color":"#ffffff"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f7f7f7","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","title":"Innovative Design Award 2017","caption":"First Runner Up","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Clever Structure Award 2016","caption":"First Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Best Engineering Design 2016","caption":"Third Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Environment Heart Award 2016","caption":"Third Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","title":"Innovative Design Award 2017","caption":"First Runner Up","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Clever Structure Award 2016","caption":"First Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Best Engineering Design 2016","caption":"Third Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Environment Heart Award 2016","caption":"Third Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","title":"Innovative Design Award 2017","caption":"First Runner Up","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Clever Structure Award 2016","caption":"First Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Best Engineering Design 2016","caption":"Third Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}},{"template":"element","type":"title","value":{"id":"","title":"Environment Heart Award 2016","caption":"Third Place","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"36px"}}]}]}]';
				case 'about-our-team':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4529","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"400px","right":"0px","bottom":"125px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About Our Team","caption":"A small river named Duden flows by","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h1","icon-font-size":"30px","title-font-size":"68px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"personnel","value":{"id":"","category":"","num-fetch":"4","thumbnail-size":"Personnel Thumbnail 2","orderby":"date","disable-link":"disable","order":"desc","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","text-align":"left","personnel-style":"modern-no-space","enable-position":"enable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"4","carousel":"disable","carousel-navigation":"navigation","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#f9f9f9","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"50px","bottom":"0px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"blockquote","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","author":"Matt Swally","text-align":"left","size":"small","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"80px","bottom":"50px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Divider"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team <br/>of expert Designers","caption":"The most powerful theme on earth","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"#939393","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts.</p>","text-align":"left","font-size":"17px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"30px","bottom":"80px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":4584,"thumbnail":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2016/11/banner-1.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":4585,"thumbnail":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2016/11/banner-2.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":4586,"thumbnail":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2016/11/banner-3.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":4587,"thumbnail":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2016/11/banner-4.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","id":4588,"thumbnail":"http://demo.goodlayers.com/traveltour/wp-content/uploads/2016/11/banner-5-150x33.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4527","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"Clever System","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_pin_alt","icon-style":"normal","image":"","title":"We Are Everywhere","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_piechart","icon-style":"normal","image":"","title":"Smart Diversification","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_cloud-download_alt","icon-style":"normal","image":"","title":"Google Fonts","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"Great Timing","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_creditcard","icon-style":"normal","image":"","title":"Credit Cards","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}}]}]}]';
				case 'our-services':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4529","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"325px","right":"0px","bottom":"205px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Services We Provide","caption":"A small river named Duden flows by their place.","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h1","icon-font-size":"30px","title-font-size":"79px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"#999999","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"enable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"left","background-color":"","background-image":"4505","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"70px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"A Little About Us","caption":"Our Story","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"41px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.</p>","text-align":"left","font-size":"17px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"enable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"140px","right":"70px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our Top Missions","caption":"Philosophy","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"41px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.</p>","text-align":"left","font-size":"17px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"right","background-color":"","background-image":"4506","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"enable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"left","background-color":"","background-image":"4501","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"70px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","title":"We Provide Solutions","caption":"Strategy","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"41px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.</p>","text-align":"left","font-size":"17px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4528","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"Clever System","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"Great Timing","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_cloud-download_alt","icon-style":"normal","image":"","title":"Google Fonts","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_piechart","icon-style":"normal","image":"","title":"Smart Diversification","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_creditcard","icon-style":"normal","image":"","title":"Credit Cards","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_pin_alt","icon-style":"normal","image":"","title":"We Are Everywhere","caption":"","content":"<p>On her way she met a copy. The copy warn ed the Little Blind Text, that where it came from it would have been.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-top","icon-size":"40px","title-size":"20px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","content-size":"15px","read-more-size":"14px","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f4f4f4","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"Interested in our services now?","caption":"Far far away, behind the word mountains, far from the countries Vokalia.","button-text":"Contact Us","button-link":"http://goodlayers.com","button-link-target":"_blank","style":"left-align-right-button","button-style":"transparent","button-border-radius":"","title-size":"30px","title-font-weight":"","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"30px"}}]}]';
				case 'contact':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4529","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"350px","right":"0px","bottom":"160px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"75px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"25px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-phone","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Phone","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these.</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">+1-2345-2345</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-envelope-o","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these.</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">Contact@goodlayers.com</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-location-arrow","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Location","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"24px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>4 apt. Flawing Street. The Grand Avenue.<br />Liverpool, UK 33342</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">View On Google Map</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"680px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"95px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"760px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Leave us your info ","caption":"and we will get back to you.","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"50px","icon-color":"","divider-color":"#2b2b2b"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1319","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","wpgmap-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#1e1e1e","icon-space":"40px","padding-bottom":"30px"}}]}]';
				case 'contact2':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4527","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"300px","right":"0px","bottom":"150px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"75px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Leave us your info ","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"25px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"30px","icon-color":"","divider-color":"#3a3a3a"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>","text-align":"left","font-size":"16px","padding-bottom":"25px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1979","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Location","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"25px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"30px","icon-color":"","divider-color":"#3a3a3a"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>4 apt. Flawing Street. The Grand Avenue.<br />Liverpool, UK 33342</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"icon-list","value":{"id":"","tabs":[{"icon":"fa fa-envelope-o","icon-hover":"fa fa-envelope-o","title":"contact@traveltourwptheme.com"},{"icon":"fa fa-phone","icon-hover":"fa fa-phone","title":"+1-3524-3356"}],"icon-size":"16px","content-size":"16px","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Map","caption":"","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"25px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"30px","icon-color":"","divider-color":"#3a3a3a"}},{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"2","wpgmap2-id":null,"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"#","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"37px","padding-bottom":"0px"}}]}]';
				case 'contact3':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4529","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"360px","right":"0px","bottom":"180px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"75px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"4528","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"65px","bottom":"80px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"London","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"104px","padding-bottom":"32px","icon-color":"","divider-color":"#ffffff"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>4 apt. Flawing Street. The Grand Avenue. Liverpool, UK 33342</p>\n<p>Tel : +44-20-2355-3456<br />\nEmail : London@traveltourWP.com</p>\n","text-align":"left","font-size":"16px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"1","wpgmap2-id":null,"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"4526","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"65px","bottom":"80px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"San Fran","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"113px","padding-bottom":"32px","icon-color":"","divider-color":"#ffffff"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>88 Flower Avenue. Kingdom St.<br />San Francisco CA 7689</p><p>Tel : +1-4533-4435-2<br />Email : Sanfran@traveltourWP.com</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"3","wpgmap2-id":null,"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"680px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"760px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"