<?php

/**

 * Created by wpbooking.

 * Developer: nasanji

 * Date: 4/26/2017

 * Version: 1.0

 */

$faq = get_post_meta(get_the_ID(), 'hotel_policy', true);

?>

<div class="content-policies <?php echo (empty($faq)?'no-faq':'')?>">

    <div class="service-content-section">

        <div class="service-details">

            <?php

            $checkin_html = get_post_meta(get_the_ID(),'check_in_time' ,TRUE);

            $checkout_html =  get_post_meta(get_the_ID(),'check_out_time' ,TRUE);

            if(!empty($checkin_html) || !empty($checkout_html)) {

                ?>

                <div class="service-detail-item">

                    <div class="service-detail-title"><?php esc_html_e('Time', 'traveler') ?></div>

                    <div class="service-detail-content">

                        <?php esc_html_e("Check In:",'traveler') ?>

                        <?php echo esc_html($checkin_html) ?>

                        <br>

                        <?php esc_html_e("Check Out:",'traveler') ?>

                        <?php echo esc_html($checkout_html) ?>

                    </div>

                </div>

            <?php } ?>

            <?php

            $hotel_booking_period = get_post_meta(get_the_ID(),'hotel_booking_period' ,TRUE);

            if(!empty($hotel_booking_period)) {

                ?>

                <div class="service-detail-item">

                    <div class="service-detail-title"><?php esc_html_e('Book before number of day', 'traveler') ?></div>

                    <div class="service-detail-content">

                        <?php echo sprintf(_n('%s day','%s days',$hotel_booking_period,'traveler'),$hotel_booking_period) ?>

                    </div>

                </div>

            <?php } ?>

            <?php

            $card = get_post_meta(get_the_ID(),'card_accepted',true);

            $card_image = array(

                'master-card' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAElElEQVRYhe3WXUxbZRgH8DdGo7hwQUpJbQsFCodDATs6DodDu7aDlo6G0hX5pjA+ChuOwhgMLV8Og2a4kTBRBjhhzGWTsE2ZZmyGKGoYEbdhxpZNzYQt0xmimVkIid78vYGGeorZVb1wT/LL+7zP857/9SHkSf3vi8up99Pa2wa2FrX/rrW3wyeK2v7Q2tsGuJx6P6IubBnWVRzCjuH7sJ144BM7hu9DV3EI6sKWYcLlu1asQ/eQ0nAa+j3v+URKw2lYh+6By3etEK6gBZbBO9BWD2ygH5rybnD5LrC2WrA2J7jcV6Ap64K2uh/a6n6oSw+Cy2kCa3OCtdWCy2/G1oru1b33XMvgHXAFLSBsrgvmvlvQ7DrKV9WHpIwqVBjy8VGiDj++uBkLcUpcSlBjX8pLSLJUIclaBVdHFr66mIxfbyhx77t4nB/To7yuAKy1CpqqPq/Z5r5bYHNdIEx2E0y980iufNeToxeJ5gq0azKwqFDgLk3jp1WLNI3FaAWO5howMpiCh9cUWJ6isXyJxvJnNJa/prF0NQbNHZlgLA4kO3p5+abeeTDZTSCqrEYYeubAlr/tgSnsRLk2C4sUhR+8+J6msNRB4dFlCo8uUHj0yT9coLA0Q8P+cjaYojd5+YaeOaiyGkE2W+uR0j0LprTHg9LixNk4Brfkcp6bcjnu6OX4MjHR7eG4nO+8HOdGWCgtdbz8lO5ZbLbWg8Rl1EHXNQ1VcbeHGMNOzIfLcSM0lOd6aCgWskPx28erzm1s8dMIxBhKefm6rmnEZdSBKMw1UHdOQVn4locofSGuh4R4dS0kBJPx8TxLYyE8P4/JQOuLePnqzikozDUgtKkaSQcmEZt/0EOk3o5JWTjmJBKeKxIJbqdJ8MsJCR6ckeDBhxubHYgApd/Jy086MAnaVA0SadiFxNYJKHLe8ECZ9qCVZnBFJOL5ViTCREyMh/unRF517GNBmZy8/MTWCUQadoGEb3NA5RpHVNbrHihrK5gEM0alYfhGKOSZEQrxuSkYV3sluHtKiLsf8E0cliPeYAFlbePlq1zjCN/mAJHpyqBsPIsI62s8YcYa6JSp6Amh8EVgEGYEAswIBJgWCHBUKoc1QYc8mwZnuuRYOC5wmx8MwvutUdi63YgwY63XbGXjWch0ZSDBmhLE7h1FuKXNK1naXkiT7RBvyYRYZXGTJhdCZqiFzOCElCvw2Im3WBGsLoYsrX7D3Ni9owjWlICIOTuinSchMzc/Bteqf9tttPcU7TwJMWcHEbEFiNw9guDtr/KMXZxxn+v7x52t9d5E7h6BiC0AETJ5iHAcg9i4n2ds4rJbkLrS3a/tgtSV7l5s3I8gdaV7tvbeW67YuB8RjmMQMnkgAlUOwsr6IUpt4AlMrnBbf1/r17/b6Htvc1FqA8LK+iFQ5YAEKG0rspI+iNJcCNpW7xOiNBdkJX0IUNpWiL/CPBTAFENqPwJp8Tu+YT+CAKYY/tHpxwl5xo99Xsbe3KRI/9M/1gJf2KRI/+u5UPY2efpZIyGEBBJCtIQQiw9lEkJSCSEvrP2dP/UfeVJPivwN+dTXjrVYrbMAAAAASUVORK5CYII=',

                'visa' => 'data:image/png;base64,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',

                'jcb' => 'data:image/png;base64,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',

                'union-pay' => 'data:image/png;base64,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',

                'american-express' => 'data:image/png;base64,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',

            );

            if(!empty($card)) {

                ?>

                <div class="service-detail-item">

                    <div class="service-detail-title"><?php esc_html_e('Accepted Cards', 'traveler') ?></div>

                    <div class="service-detail-content list-card-acd">

                        <?php echo do_shortcode('[st_hotel_detail_card_accept]') ?>

                    </div>

                </div>

            <?php } ?>



        </div>

    </div>

</div>

<?php if(!empty($faq)){ ?>

<div class="content-FAQ">

    <?php

        foreach($faq as $key => $val){

            ?>

            <div class="faq-item">

                <h4 class="ask"><?php echo esc_attr($val['title'])?></h4>

                <p class="ans"><?php echo do_shortcode($val['policy_description'])?></p>

            </div>

            <?php

        }

    ?>

</div>

<?php } ?>