<?php
/**
 * Travel Booking Agency: Block Patterns
 *
 * @package Travel Booking Agency
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'travel-booking-agency',
		array( 'label' => __( 'Travel Booking Agency', 'travel-booking-agency' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'travel-booking-agency/banner-section',
		array(
			'title'      => __( 'Banner Section', 'travel-booking-agency' ),
			'categories' => array( 'travel-booking-agency' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/images/slider.png\",\"id\":1864,\"dimRatio\":80,\"customOverlayColor\":\"#00000000\",\"minHeight\":600,\"align\":\"full\",\"className\":\"travel-booking-agency-slider-section\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover alignfull travel-booking-agency-slider-section\" style=\"min-height:600px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-80 has-background-dim\" style=\"background-color:#00000000\"></span><img class=\"wp-block-cover__image-background wp-image-1864\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/images/slider.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"50%\",\"className\":\"slider-section\"} -->\n<div class=\"wp-block-column slider-section\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"style\":{\"color\":{\"background\":\"#f44c28\"},\"typography\":{\"fontSize\":\"14px\"}},\"textColor\":\"white\",\"className\":\"sticker-slider\"} -->\n<p class=\"sticker-slider has-white-color has-text-color has-background\" style=\"background-color:#f44c28;font-size:14px\">Tour &amp; Travel</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":1,\"style\":{\"typography\":{\"fontSize\":\"42px\"}},\"textColor\":\"white\",\"className\":\"slider-heading\"} -->\n<h1 class=\"wp-block-heading slider-heading has-white-color has-text-color\" style=\"font-size:42px\">The Best Way To Plan Your Trip Around the World</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\",\"className\":\"slider-para\"} -->\n<p class=\"slider-para has-white-color has-text-color\" style=\"font-size:15px\">Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"slider-button\"} -->\n<div class=\"wp-block-buttons slider-button\"><!-- wp:button {\"backgroundColor\":\"white\",\"style\":{\"color\":{\"text\":\"#222222\"},\"border\":{\"radius\":\"30px\"},\"typography\":{\"fontSize\":\"18px\"}}} -->\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:18px\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background wp-element-button\" style=\"border-radius:30px;color:#222222\">View Tours</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\",\"className\":\"slider-blank\"} -->\n<div class=\"wp-block-column slider-blank\" style=\"flex-basis:50%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'travel-booking-agency/popular-tour-section',
		array(
			'title'      => __( 'Popular Tour Section', 'travel-booking-agency' ),
			'categories' => array( 'travel-booking-agency' ),
			'content'    => "<!-- wp:columns {\"align\":\"wide\",\"className\":\"travel-booking-agency-popular-tour-section\"} -->\n<div class=\"wp-block-columns alignwide travel-booking-agency-popular-tour-section\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/images/tab-background.png\",\"id\":1882,\"dimRatio\":0,\"focalPoint\":{\"x\":0.5,\"y\":0.5},\"minHeight\":100,\"className\":\"tour-section\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover tour-section\" style=\"min-height:100px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1882\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/images/tab-background.png\" style=\"object-position:50% 50%\" data-object-fit=\"cover\" data-object-position=\"50% 50%\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#f44c28\"},\"typography\":{\"fontSize\":\"28px\"}},\"className\":\"tour-heading\"} -->\n<p class=\"tour-heading has-text-color\" style=\"color:#f44c28;font-size:28px\">Most Popular Tours</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {\"className\":\"tours-tab\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group tours-tab\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"backgroundColor\":\"white\",\"className\":\"tab-section\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-center tab-section has-white-background-color has-background\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"14%\",\"className\":\"featured-tab\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center featured-tab\" style=\"flex-basis:14%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"20px\"},\"color\":{\"text\":\"#f44c28\"}}} -->\n<p class=\"has-text-color\" style=\"color:#f44c28;font-size:20px\">Featured</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"14%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:14%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<p class=\"has-black-color has-text-color\" style=\"font-size:20px\">Lifestyle</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"14%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:14%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<p class=\"has-black-color has-text-color\" style=\"font-size:20px\">Food & Drink</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"14%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:14%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<p class=\"has-black-color has-text-color\" style=\"font-size:20px\">Cities &amp; Town</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"14%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:14%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<p class=\"has-black-color has-text-color\" style=\"font-size:20px\">Outdoors</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"14%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:14%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<p class=\"has-black-color has-text-color\" style=\"font-size:20px\">Culture &amp; History</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"14%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:14%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<p class=\"has-black-color has-text-color\" style=\"font-size:20px\">Entertainment</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:columns {\"className\":\"post-section\"} -->\n<div class=\"wp-block-columns post-section\"><!-- wp:column {\"className\":\"post-col-section\"} -->\n<div class=\"wp-block-column post-col-section\"><!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/images/post1.png\",\"id\":3484,\"dimRatio\":50,\"minHeight\":200,\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover\" style=\"min-height:200px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3484\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/images/post1.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"22px\"},\"color\":{\"background\":\"#f44c28\"}},\"textColor\":\"white\",\"className\":\"post-heading\"} -->\n<h3 class=\"wp-block-heading post-heading has-white-color has-text-color has-background\" style=\"background-color:#f44c28;font-size:22px\">Special Package 01</h3>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<h4 class=\"wp-block-heading has-black-color has-text-color\" style=\"font-size:20px\">Starting From $79</h4>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"backgroundColor\":\"black\",\"className\":\"post-content\"} -->\n<div class=\"wp-block-columns post-content has-black-background-color has-background\"><!-- wp:column {\"width\":\"15%\",\"className\":\"admin-section\"} -->\n<div class=\"wp-block-column admin-section\" style=\"flex-basis:15%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">9+</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"className\":\"location-section\"} -->\n<div class=\"wp-block-column location-section\" style=\"flex-basis:25%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">Europe</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\",\"className\":\"time-section\"} -->\n<div class=\"wp-block-column time-section\" style=\"flex-basis:30%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">7 Days</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\",\"className\":\"rating-section\"} -->\n<div class=\"wp-block-column rating-section\" style=\"flex-basis:30%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">9.9 Ratings</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"post-col-section\"} -->\n<div class=\"wp-block-column post-col-section\"><!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/images/post2.png\",\"id\":3519,\"dimRatio\":50,\"minHeight\":200,\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover\" style=\"min-height:200px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3519\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/images/post2.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"22px\"},\"color\":{\"background\":\"#f44c28\"}},\"textColor\":\"white\",\"className\":\"post-heading\"} -->\n<h3 class=\"wp-block-heading post-heading has-white-color has-text-color has-background\" style=\"background-color:#f44c28;font-size:22px\">Special Package 02</h3>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<h4 class=\"wp-block-heading has-black-color has-text-color\" style=\"font-size:20px\">Starting From $79</h4>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"backgroundColor\":\"black\",\"className\":\"post-content\"} -->\n<div class=\"wp-block-columns post-content has-black-background-color has-background\"><!-- wp:column {\"width\":\"15%\",\"className\":\"admin-section\"} -->\n<div class=\"wp-block-column admin-section\" style=\"flex-basis:15%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">9+</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"className\":\"location-section\"} -->\n<div class=\"wp-block-column location-section\" style=\"flex-basis:25%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">Europe</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\",\"className\":\"time-section\"} -->\n<div class=\"wp-block-column time-section\" style=\"flex-basis:30%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">7 Days</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\",\"className\":\"rating-section\"} -->\n<div class=\"wp-block-column rating-section\" style=\"flex-basis:30%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">9.9 Ratings</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"post-col-section\"} -->\n<div class=\"wp-block-column post-col-section\"><!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/images/post3.png\",\"id\":3521,\"dimRatio\":50,\"minHeight\":200,\"isDark\":false,\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover is-light\" style=\"min-height:200px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3521\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/images/post3.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"22px\"},\"color\":{\"background\":\"#f44c28\"}},\"textColor\":\"white\",\"className\":\"post-heading\"} -->\n<h3 class=\"wp-block-heading post-heading has-white-color has-text-color has-background\" style=\"background-color:#f44c28;font-size:22px\">Special Package 03</h3>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"fontSize\":\"20px\"}},\"textColor\":\"black\"} -->\n<h4 class=\"wp-block-heading has-black-color has-text-color\" style=\"font-size:20px\">Starting From $79</h4>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"backgroundColor\":\"black\",\"className\":\"post-content\"} -->\n<div class=\"wp-block-columns post-content has-black-background-color has-background\"><!-- wp:column {\"width\":\"15%\",\"className\":\"admin-section\"} -->\n<div class=\"wp-block-column admin-section\" style=\"flex-basis:15%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">9+</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"className\":\"location-section\"} -->\n<div class=\"wp-block-column location-section\" style=\"flex-basis:25%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">Europe</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\",\"className\":\"time-section\"} -->\n<div class=\"wp-block-column time-section\" style=\"flex-basis:30%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">7 Days</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\",\"className\":\"rating-section\"} -->\n<div class=\"wp-block-column rating-section\" style=\"flex-basis:30%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:15px\">9.9 Ratings</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
		)
	);
}