<?php
/**
 * Custom theme functions.
 *
 * This file contains hook functions attached to theme hooks.
 *
 * @package tour_travel_package
 */

if ( ! function_exists( 'tour_travel_package_skip_to_content' ) ) :
	/**
	 * Add Skip to content.
	 *
	 * @since 1.0.0
	 */
	function tour_travel_package_skip_to_content() {
	?><a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'tour-travel-package' ); ?></a><?php
	}
endif;

add_action( 'tour_travel_package_action_before', 'tour_travel_package_skip_to_content', 15 );

// Middle Header

if ( ! function_exists( 'tour_travel_package_site_branding' ) ) :

	/**
	 * Site branding.
	 *
	 * @since 1.0.0
	 */
	function tour_travel_package_site_branding() {
		$header_phone_number = tour_travel_package_get_option( 'header_phone_number' );
		$header_phone_text = tour_travel_package_get_option( 'header_phone_text' );
		$data_sticky = tour_travel_package_get_option( 'show_data_sticky_setting' );
		?>

		<!-- responsive menu -->
		<div id="middle-header" data-sticky= "<?php echo esc_attr($data_sticky); ?>">
			<div class="container">
				<div class="row">
				    <div class="col-xl-3 col-lg-3 col-md-4 align-self-center">
					    <div class="site-branding mb-3 mb-lg-0">
							<?php tour_travel_package_the_custom_logo(); ?>
							<?php $show_title = tour_travel_package_get_option( 'show_title' ); ?>
							<?php $show_tagline = tour_travel_package_get_option( 'show_tagline' ); ?>
							<?php if ( true === $show_title || false === $show_tagline ) :  ?>
								<div id="site-identity">
									<?php if ( true === $show_title ) :  ?>
										<?php if ( is_front_page() ) : ?>
											<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
									<?php endif; ?>
									<?php if ( true === $show_tagline ) :  ?>
										<p class="site-description"><?php bloginfo( 'description' ); ?></p>
									<?php endif; ?>
								</div>
							<?php endif; ?>
					    </div>
					</div>

					<!-- right menu -->
					<div class="col-lg-6 col-md-2 col-5 align-self-center">
						<div class="toggle-menu gb_menu text-md-start">
							<button onclick="tour_travel_package_gb_Menu_open()" class="gb_toggle p-2"><?php esc_html_e('Menu','tour-travel-package'); ?></button>
						</div>
						<div id="gb_responsive" class="nav side_gb_nav">
							<nav id="top_gb_menu" class="gb_nav_menu" role="navigation" aria-label="<?php esc_attr_e( 'Menu', 'tour-travel-package' ); ?>">
								<?php
								    wp_nav_menu( array( 
										'theme_location' => 'primary-menu',
										'container_class' => 'gb_navigation clearfix' ,
										'menu_class' => 'clearfix',
										'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav mb-0 px-0">%3$s</ul>',
										'fallback_cb' => 'wp_page_menu',
								    ) ); 
								?>
								<a href="javascript:void(0)" class="closebtn gb_menu" onclick="tour_travel_package_gb_Menu_close()">x<span class="screen-reader-text"><?php esc_html_e('Close Menu','tour-travel-package'); ?></span></a>
							</nav>
						</div>
					</div>

					<div class="col-lg-3 col-md-6 col-7 align-self-center text-md-end text-center ">
						<?php if( !empty($header_phone_number) ):?>
						    <span class="header-button mb-0"><span class="dashicons dashicons-phone"></span> <?php echo esc_html($header_phone_text);?>:<span><a href="tel:<?php echo esc_html($header_phone_number);?>"><?php echo esc_html($header_phone_number);?></span></a></span>
						<?php endif;?>
					</div>
				</div>
			</div>
		</div>

	    <?php
	}

endif;

add_action( 'tour_travel_package_action_header', 'tour_travel_package_site_branding' );


/////////////////////////////////// copyright start/////////////////////////////

if ( ! function_exists( 'tour_travel_package_footer_copyright' ) ) :

	/**
	 * Footer copyright
	 *
	 * @since 1.0.0
	 */
	function tour_travel_package_footer_copyright() {

		// Check if footer is disabled.
		$footer_status = apply_filters( 'tour_travel_package_filter_footer_status', true );
		if ( true !== $footer_status ) {
			return;
		}

		// Copyright content.
		$copyright_text = tour_travel_package_get_option( 'copyright_text' );
		$copyright_text = apply_filters( 'tour_travel_package_filter_copyright_text', $copyright_text );
		if ( ! empty( $copyright_text ) ) {
			$copyright_text = wp_kses_data( $copyright_text );
		}

		// Powered by content.
		$powered_by_text = sprintf( __( 'Tour Travel Package by %s', 'tour-travel-package' ), '<span>' . __( 'Mizan Themes', 'tour-travel-package' ) . '</span>' );
		?>

		<div class="colophon-inner">
		    <?php if ( ! empty( $copyright_text ) ) : ?>
			    <div class="colophon-column">
			    	<div class="copyright">
			    		<?php echo $copyright_text; ?>
			    	</div><!-- .copyright -->
			    </div><!-- .colophon-column -->
		    <?php endif; ?>

		    <?php if ( ! empty( $powered_by_text ) ) : ?>
			    <div class="colophon-column">
			    	<div class="site-info">
			    		<a href="<?php echo esc_url('https://www.mizanthemes.com/elementor/free-travel-wordpress-theme/','tour-travel-package'); ?>"><?php echo $powered_by_text; ?></a>
			    	</div><!-- .site-info -->
			    </div><!-- .colophon-column -->
		    <?php endif; ?>

		</div><!-- .colophon-inner -->

	    <?php
	}

endif;

add_action( 'tour_travel_package_action_footer', 'tour_travel_package_footer_copyright', 10 );

// /////////////////////////////////sidebar//////////////////


if ( ! function_exists( 'tour_travel_package_add_sidebar' ) ) :

	/**
	 * Add sidebar.
	 *
	 * @since 1.0.0
	 */
	function tour_travel_package_add_sidebar() {

		global $post;

		$global_layout = tour_travel_package_get_option( 'global_layout' );
		$global_layout = apply_filters( 'tour_travel_package_filter_theme_global_layout', $global_layout );

		// Check if single.
		if ( $post && is_singular() ) {
			$post_options = get_post_meta( $post->ID, 'tour_travel_package_theme_settings', true );
			if ( isset( $post_options['post_layout'] ) && ! empty( $post_options['post_layout'] ) ) {
				$global_layout = $post_options['post_layout'];
			}
		}

		// Include primary sidebar.
		if ( 'no-sidebar' !== $global_layout ) {
			get_sidebar();
		}
		// Include Secondary sidebar.
		switch ( $global_layout ) {
			case 'three-columns':
			get_sidebar( 'secondary' );
			break;

			default:
			break;
		}

		// Include Secondary sidebar.
		switch ( $global_layout ) {
			case 'four-columns':
			get_sidebar( 'secondary' );
			break;

			default:
			break;
		}

	}

endif;

add_action( 'tour_travel_package_action_sidebar', 'tour_travel_package_add_sidebar' );

//////////////////////////////////////// single page


if ( ! function_exists( 'tour_travel_package_add_image_in_single_display' ) ) :

	/**
	 * Add image in single post.
	 *
	 * @since 1.0.0
	 */
	function tour_travel_package_add_image_in_single_display() {

		global $post;

		if ( has_post_thumbnail() ) {

			$values = get_post_meta( $post->ID, 'tour_travel_package_theme_settings', true );
			$tour_travel_package_theme_settings_single_image = isset( $values['single_image'] ) ? esc_attr( $values['single_image'] ) : '';

			if ( ! $tour_travel_package_theme_settings_single_image ) {
				$tour_travel_package_theme_settings_single_image = tour_travel_package_get_option( 'single_image' );
			}

			if ( 'disable' !== $tour_travel_package_theme_settings_single_image ) {
				$args = array(
					'class' => 'aligncenter',
				);
				the_post_thumbnail( esc_attr( $tour_travel_package_theme_settings_single_image ), $args );
			}
		}

	}

endif;

add_action( 'tour_travel_package_single_image', 'tour_travel_package_add_image_in_single_display' );

if ( ! function_exists( 'tour_travel_package_footer_goto_top' ) ) :

	/**
	 * Go to top.
	 *
	 * @since 1.0.0
	 */
	function tour_travel_package_footer_goto_top() {

		$show_scroll_to_top = tour_travel_package_get_option( 'show_scroll_to_top' );
        if ( true === $show_scroll_to_top ) :
		echo '<a href="#page" class="scrollup" id="btn-scrollup"><i class="fa fa-angle-up"><span class="screen-reader-text">' . esc_html__( 'Scroll Up', 'tour-travel-package' ) . '</span></i></a>';
	    endif;

	}

endif;

add_action( 'tour_travel_package_action_after', 'tour_travel_package_footer_goto_top', 20 );