<?php
/**
 * Helper functions related to customizer and options.
 *
 * @package tour_travel_package
 */

if ( ! function_exists( 'tour_travel_package_get_global_layout_options' ) ) :

	/**
	 * Returns global layout options.
	 *
	 * @since 1.0.0 
	 *
	 * @return array Options array.
	 */
	function tour_travel_package_get_global_layout_options() {

		$choices = array(
			'left-sidebar'  => esc_html__( 'Primary Sidebar - Content', 'tour-travel-package' ),
			'right-sidebar' => esc_html__( 'Content - Primary Sidebar', 'tour-travel-package' ),
			'three-columns' => esc_html__( 'Three Columns', 'tour-travel-package' ),
			'four-columns' => esc_html__( 'Four Columns', 'tour-travel-package' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'tour-travel-package' ),
		);
		$output = apply_filters( 'tour_travel_package_filter_layout_options', $choices );
		return $output;

	}

endif;

if ( ! function_exists( 'tour_travel_package_get_archive_layout_options' ) ) :

	/**
	 * Returns archive layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function tour_travel_package_get_archive_layout_options() {

		$choices = array(
			'full'    => esc_html__( 'Full Post', 'tour-travel-package' ),
			'excerpt' => esc_html__( 'Post Excerpt', 'tour-travel-package' ),
		);
		$output = apply_filters( 'tour_travel_package_filter_archive_layout_options', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'tour_travel_package_get_image_sizes_options' ) ) :

	/**
	 * Returns image sizes options.
	 *
	 * @since 1.0.0
	 *
	 * @param bool  $add_disable True for adding No Image option.
	 * @param array $allowed Allowed image size options.
	 * @return array Image size options.
	 */
	function tour_travel_package_get_image_sizes_options( $add_disable = true, $allowed = array(), $show_dimension = true ) {

		global $_wp_additional_image_sizes;
		$get_intermediate_image_sizes = get_intermediate_image_sizes();
		$choices = array();
		if ( true === $add_disable ) {
			$choices['disable'] = esc_html__( 'No Image', 'tour-travel-package' );
		}
		$choices['thumbnail'] = esc_html__( 'Thumbnail', 'tour-travel-package' );
		$choices['medium']    = esc_html__( 'Medium', 'tour-travel-package' );
		$choices['large']     = esc_html__( 'Large', 'tour-travel-package' );
		$choices['full']      = esc_html__( 'Full (original)', 'tour-travel-package' );

		if ( true === $show_dimension ) {
			foreach ( array( 'thumbnail', 'medium', 'large' ) as $key => $_size ) {
				$choices[ $_size ] = $choices[ $_size ] . ' (' . get_option( $_size . '_size_w' ) . 'x' . get_option( $_size . '_size_h' ) . ')';
			}
		}

		if ( ! empty( $_wp_additional_image_sizes ) && is_array( $_wp_additional_image_sizes ) ) {
			foreach ( $_wp_additional_image_sizes as $key => $size ) {
				$choices[ $key ] = $key;
				if ( true === $show_dimension ){
					$choices[ $key ] .= ' ('. $size['width'] . 'x' . $size['height'] . ')';
				}
			}
		}

		if ( ! empty( $allowed ) ) {
			foreach ( $choices as $key => $value ) {
				if ( ! in_array( $key, $allowed ) ) {
					unset( $choices[ $key ] );
				}
			}
		}

		return $choices;

	}

endif;


if ( ! function_exists( 'tour_travel_package_get_image_alignment_options' ) ) :

	/**
	 * Returns image options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function tour_travel_package_get_image_alignment_options() {

		$choices = array(
			'none'   => _x( 'None', 'alignment', 'tour-travel-package' ),
			'left'   => _x( 'Left', 'alignment', 'tour-travel-package' ),
			'center' => _x( 'Center', 'alignment', 'tour-travel-package' ),
			'right'  => _x( 'Right', 'alignment', 'tour-travel-package' ),
		);
		return $choices;

	}

endif;

if ( ! function_exists( 'tour_travel_package_get_featured_slider_transition_effects' ) ) :

	/**
	 * Returns the featured slider transition effects.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function tour_travel_package_get_featured_slider_transition_effects() {

		$choices = array(
			'fade'       => _x( 'fade', 'transition effect', 'tour-travel-package' ),
			'fadeout'    => _x( 'fadeout', 'transition effect', 'tour-travel-package' ),
			'none'       => _x( 'none', 'transition effect', 'tour-travel-package' ),
			'scrollHorz' => _x( 'scrollHorz', 'transition effect', 'tour-travel-package' ),
		);
		$output = apply_filters( 'tour_travel_package_filter_featured_slider_transition_effects', $choices );

		if ( ! empty( $output ) ) {
			ksort( $output );
		}

		return $output;

	}

endif;

if ( ! function_exists( 'tour_travel_package_get_featured_slider_content_options' ) ) :

	/**
	 * Returns the featured slider content options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function tour_travel_package_get_featured_slider_content_options() {

		$choices = array(
			'home-page' => esc_html__( 'Static Front Page Only', 'tour-travel-package' ),
			'disabled'  => esc_html__( 'Disabled', 'tour-travel-package' ),
		);
		$output = apply_filters( 'tour_travel_package_filter_featured_slider_content_options', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'tour_travel_package_get_featured_slider_type' ) ) :

	/**
	 * Returns the featured slider type.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function tour_travel_package_get_featured_slider_type() {

		$choices = array(
			'featured-page' => __( 'Featured Pages', 'tour-travel-package' ),
		);

		$output = apply_filters( 'tour_travel_package_filter_featured_slider_type', $choices );

		if ( ! empty( $output ) ) {
			ksort( $output );
		}

		return $output;

	}

endif;

if ( ! function_exists( 'tour_travel_package_get_numbers_dropdown_options' ) ) :

	/**
	 * Returns numbers dropdown options.
	 *
	 * @since 1.0.0
	 *
	 * @param int $min Min.
	 * @param int $max Max.
	 * @param string $prefix Prefix.
	 * @param string $suffix Suffix.
	 *
	 * @return array Options array.
	 */
	function tour_travel_package_get_numbers_dropdown_options( $min = 1, $max = 4, $prefix = '', $suffix = '' ) {

		$output = array();

		if ( $min <= $max ) {
			for ( $i = $min; $i <= $max; $i++ ) {
				$string = $prefix . $i . $suffix;
				$output[ $i ] = $string;
			}
		}

		return $output;

	}

endif;