<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package tour_travel_package
 */

?>
<?php
	/**
	 * Hook - tour_travel_package_action_doctype.
	 *
	 * @hooked tour_travel_package_doctype -  10
	 */
	do_action( 'tour_travel_package_action_doctype' );
?>
<head>
	<?php
	/**
	 * Hook - tour_travel_package_action_head.
	 *
	 * @hooked tour_travel_package_head -  10
	 */
	do_action( 'tour_travel_package_action_head' );
	?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php do_action( 'wp_body_open' ); ?>

	<?php 
	$show_preloader = tour_travel_package_get_option( 'show_preloader_setting' );
        if ( true === $show_preloader ) : ?>
			<div id="preloader" class="loader-head">
				<div class="preloader">
				    <div class="spinner"></div>
				    <div class="spinner-2"></div>
				</div>
			</div>
	<?php endif; ?>

	<?php
	/**
	 * Hook - tour_travel_package_action_before.
	 *
	 * @hooked tour_travel_package_page_start - 10
	 * @hooked tour_travel_package_skip_to_content - 15
	 */
	do_action( 'tour_travel_package_action_before' );
	?>

    <?php
	  /**
	   * Hook - tour_travel_package_action_before_header.
	   *
	   * @hooked tour_travel_package_header_start - 10
	   */
	  do_action( 'tour_travel_package_action_before_header' );
	?>
		<?php
		/**
		 * Hook - tour_travel_package_action_header.
		 *
		 * @hooked tour_travel_package_site_branding - 10
		 */
		do_action( 'tour_travel_package_action_header' );
		?>
    <?php
	  /**
	   * Hook - tour_travel_package_action_after_header.
	   *
	   * @hooked tour_travel_package_header_end - 10
	   */
	  do_action( 'tour_travel_package_action_after_header' );
	?>

	<?php
	/**
	 * Hook - tour_travel_package_action_before_content.
	 *
	 * @hooked tour_travel_package_content_start - 10
	 */
	do_action( 'tour_travel_package_action_before_content' );
	?>

	<!-- <?php
	  /**
	   * Hook - tour_travel_package_action_content.
	   */
	  do_action( 'tour_travel_package_action_content' );
	?> -->

