<?php
/**
 * Review order table
 *
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.3.0
 */
if (!defined('ABSPATH')) {
    exit;
}
$hotel_alone_in_setting  = st()->get_option('hotel_alone_assign_hotel', '');
$class_wrapper = 'woocommerce-checkout-review-order-table';
if(!empty($hotel_alone_in_setting)){
	$class_wrapper = 'woocommerce-checkout-review-order-table1';
}
?>

<div class="<?php echo esc_attr($class_wrapper); ?> booking-item-payment">
    <?php
    do_action('woocommerce_review_order_before_cart_contents');

    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

        $is_woo_product = false;
        if(!isset($cart_item['st_booking_data']))
            $is_woo_product = true;

        //product_id

        $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);

        if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_checkout_cart_item_visible', TRUE, $cart_item, $cart_item_key)) {

            $product_url = '';
            $post_type = FALSE;
            // Traveler
            if (isset($cart_item['st_booking_data']) and !empty($cart_item['st_booking_data'])) {

                $st_booking_data = $cart_item['st_booking_data'];

                $post_type = isset($st_booking_data['st_booking_post_type']) ? $st_booking_data['st_booking_post_type'] : FALSE;

                $booking_id = isset($st_booking_data['st_booking_id']) ? $st_booking_data['st_booking_id'] : FALSE;
                if ($booking_id)
                    $product_url = esc_url(get_permalink($booking_id));
            }else{
                $product_url = esc_url($_product->get_permalink($cart_item));
            }

            ?>
            <header class="clearfix">
                <div class="col-left">
                    <h5 class="booking-item-payment-title">
                        <?php
                        if (!$_product->is_visible()){
                            echo apply_filters('woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key) . '&nbsp;';
                        }else{
                            if(isset($cart_item['st_booking_data']) && isset($cart_item['st_booking_data']['st_booking_post_type']) && $cart_item['st_booking_data']['st_booking_post_type'] == 'st_hotel'){
                                $st_booking_data = $cart_item['st_booking_data'];
                                $hotel_id = $st_booking_data['st_booking_id'];
                                $room_id = $st_booking_data['room_id'];
echo apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s" target="_blank">%s</a>', get_the_permalink($hotel_id), get_the_title($hotel_id)), $cart_item, $cart_item_key);
                            }else{
                                echo apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s" target="_blank">%s </a>', $product_url, $_product->get_title()), $cart_item, $cart_item_key);
                            }
                        }

                        // Meta data
                        echo wc_get_formatted_cart_item_data($cart_item);

                        // Backorder notification
                        if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity']))
                            echo '<p class="backorder_notification">' . __('Available on backorder', 'traveler') . '</p>';
                        ?>
                    </h5>
                    <?php
                    if(!$is_woo_product) {
                        $address = get_post_meta($booking_id, 'address', true);
                    ?>
                        <p class="room-name">
                            <?php
                            $st_booking_data = $cart_item['st_booking_data'];
                            $booking_id = isset($st_booking_data['st_booking_id']) ? $st_booking_data['st_booking_id'] : false;
                        $hotel_alone_in_setting = st()->get_option('hotel_alone_assign_hotel', '');
                        if(isset($st_booking_data['st_booking_post_type']) && $st_booking_data['st_booking_post_type'] == 'st_hotel' && $hotel_alone_in_setting == $booking_id){
echo esc_html__('Room Name', 'traveler') . ': ' . sprintf('<a href="%s" target="_blank">%s </a>', get_the_permalink($st_booking_data['room_id']), get_the_title($st_booking_data['room_id']));
                        }
                            ?>
                        </p>
                            <?php
                            if(!empty($address)){
                            ?>
                            <p class="address"><?php echo TravelHelper::getNewIcon('Ico_maps', '#666666', '15px', '15px', true); ?><?php echo esc_html($address); ?> </p>
                            <?php } ?>
                    <?php } ?>
                </div>
                <a class="booking-item-payment-img" target="_blank" href="<?php echo esc_url($product_url); ?>">
                    <?php
                    if (isset($cart_item['st_booking_data']) and !empty($cart_item['st_booking_data'])) {
                        $st_booking_data = $cart_item['st_booking_data'];
                        $booking_id = isset($st_booking_data['st_booking_id']) ? $st_booking_data['st_booking_id'] : FALSE;

                        $hotel_alone_in_setting = st()->get_option('hotel_alone_assign_hotel', '');
                        if(isset($st_booking_data['st_booking_post_type']) && $st_booking_data['st_booking_post_type'] == 'st_hotel' && $hotel_alone_in_setting == $booking_id) {
                            echo get_the_post_thumbnail($st_booking_data['room_id'], 'thumbnail', array('alt' => TravelHelper::get_alt_image(get_post_thumbnail_id())));
                        }else{
                            echo get_the_post_thumbnail($booking_id, 'thumbnail', array('alt' => TravelHelper::get_alt_image(get_post_thumbnail_id())));
                        }

                    } else {
                        $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

                        if (!$_product->is_visible())
                            echo balanceTags($thumbnail);
                        else
                            echo balanceTags($thumbnail);
                    }
                    ?>
                </a>
            </header>

        <?php
        }
    }

    do_action('woocommerce_review_order_after_cart_contents');
    ?>
    <ul class="booking-item-payment-details">
        <li>
            <ul class="booking-item-payment-price">
                <li>
                    <p class="booking-item-payment-price-title"><?php _e('Subtotal', 'traveler'); ?>

                    </p>

                    <p class="booking-item-payment-price-amount"><?php wc_cart_totals_subtotal_html(); ?></p>
                </li>
                <?php foreach (WC()->cart->get_coupons() as $code => $coupon) : ?>

                    <li>
                        <p class="booking-item-payment-price-title"><?php wc_cart_totals_coupon_label($coupon); ?>

                        </p>

                        <p class="booking-item-payment-price-amount"><?php wc_cart_totals_coupon_html($coupon); ?></p>
                    </li>
                <?php endforeach; ?>

                <?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>

                    <?php do_action('woocommerce_review_order_before_shipping'); ?>

                    <?php wc_cart_totals_shipping_html(); ?>

                    <?php do_action('woocommerce_review_order_after_shipping'); ?>

                <?php endif; ?>

                <?php foreach (WC()->cart->get_fees() as $fee) : ?>
                    <li>
                        <p class="booking-item-payment-price-title"><?php echo esc_html($fee->name); ?>

                        </p>

                        <p class="booking-item-payment-price-amount"><?php wc_cart_totals_fee_html($fee); ?></p>
                    </li>
                <?php endforeach; ?>

                <?php if (WC()->cart->get_tax_price_display_mode === 'excl') : ?>
                    <?php if (get_option('woocommerce_tax_total_display') === 'itemized') : ?>
                        <?php foreach (WC()->cart->get_tax_totals() as $code => $tax) : ?>
                            <li class="tax-rate tax-rate-<?php echo sanitize_title($code); ?>">
                                <p class="booking-item-payment-price-title"><?php echo esc_html($tax->label); ?>

                                </p>

                                <p class="booking-item-payment-price-amount"><?php echo wp_kses_post($tax->formatted_amount); ?></p>
                            </li>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <li class="tax-total">
                            <p class="booking-item-payment-price-title"><?php echo esc_html(WC()->countries->tax_or_vat()); ?>

                            </p>

                            <p class="booking-item-payment-price-amount"><?php echo wc_price(WC()->cart->get_taxes_total()); ?></p>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>


            </ul>
        </li>
    </ul>
    <?php do_action('woocommerce_review_order_before_order_total'); ?>

    <p class="booking-item-payment-total"><?php _e('Total', 'traveler'); ?>:
        <span><?php wc_cart_totals_order_total_html(); ?></span>
    </p>

    <?php do_action('woocommerce_review_order_after_order_total'); ?>

</div>